// spconvDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "cfbmp.h"
#include "stdio.h"
#include "stdlib.h"
#include "spconv.h"
#include "spconvDlg.h"
#include "DirSelectDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WŎgĂ CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	// _CAO f[^
		//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard ͉z֐𐶐I[o[Ch܂
	//{{AFX_VIRTUAL(CAboutDlg)
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// bZ[W nh܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpconvDlg _CAO

CSpconvDlg::CSpconvDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSpconvDlg::IDD, pParent)
	, m_spReadTo(_T(""))
	, m_spReadCount(0)
	, m_palReadCount(0)
	, m_palReadTo(0)
	, m_csvList(_T(""))
	, m_scriptBasePath(_T(""))
	, m_spAssumedPal(0)
	, m_spReadOffset(0)
	, m_palReadOffset(0)
	, m_bmpBmpFilename(_T(""))
	, m_bmpSpSizeX(1)
	, m_bmpSpSizeY(1)
	, m_bmpSpFrameCount(1)
	, m_bmpSpReadTo(_T(""))
	, m_bmpSpReadOffset(0)
	, m_bmpPalReadTo(0)
	, m_bmpPalReadOffset(0)
	, m_bmpPalReadCount(16)
	, m_bmpPalShift(FALSE)
	, m_spSaveSpFilename(_T(""))
	, m_spSaveSpFrom(_T("00"))
	, m_spSaveSpCount(256)
	, m_spSavePalFilename(_T(""))
	, m_spSavePalFrom(0)
	, m_spSavePalCount(16)
	, m_bmpSaveAutoSw(FALSE)
	, m_scriptFilename(_T(""))
{
	//{{AFX_DATA_INIT(CSpconvDlg)
	m_BmpFile = _T("");
	m_DirName = _T("");
	m_MainName = _T("");
	m_PalFile = _T("");
	m_SpFile = _T("");
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSpconvDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSpconvDlg)
	DDX_Text(pDX, IDC_BMPFILE, m_BmpFile);
	DDX_Text(pDX, IDC_DIRNAME, m_DirName);
	DDX_Text(pDX, IDC_MAINNAME, m_MainName);
	DDX_Text(pDX, IDC_PALFILE, m_PalFile);
	DDX_Text(pDX, IDC_SPFILE, m_SpFile);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_BUTTON_LOADBMP, m_loadBmpButton);
	DDX_Control(pDX, IDC_BUTTON_CONV_TO_SP, m_convToSpButton);
	DDX_Text(pDX, IDC_EDIT_SP_READ_TO, m_spReadTo);
	DDV_MaxChars(pDX, m_spReadTo, 2);
	//  DDX_Text(pDX, IDC_EDIT_PAL_READ_TO, m_palReadTo);
	DDX_Text(pDX, IDC_EDIT_SP_COUNT, m_spReadCount);
	DDV_MinMaxInt(pDX, m_spReadCount, 0, 256);
	DDX_Text(pDX, IDC_EDIT_PAL_COUNT, m_palReadCount);
	DDV_MinMaxInt(pDX, m_palReadCount, 0, 16);
	DDX_Text(pDX, IDC_EDIT_PAL_READ_TO, m_palReadTo);
	DDV_MinMaxInt(pDX, m_palReadTo, 0, 15);
	DDX_Text(pDX, IDC_EDIT_CSVLIST, m_csvList);
	DDX_Text(pDX, IDC_EDIT_SCRIPT_BASEPATH, m_scriptBasePath);
	DDX_Text(pDX, IDC_EDIT_SP_ASSUMED_PAL, m_spAssumedPal);
	DDV_MinMaxInt(pDX, m_spAssumedPal, 0, 15);
	DDX_Text(pDX, IDC_EDIT_SP_READ_OFFSET, m_spReadOffset);
	DDV_MinMaxInt(pDX, m_spReadOffset, 0, 255);
	DDX_Text(pDX, IDC_EDIT_PAL_READ_OFFSET, m_palReadOffset);
	DDV_MinMaxInt(pDX, m_palReadOffset, 0, 15);
	DDX_Text(pDX, IDC_EDIT_BMP_FILENAME, m_bmpBmpFilename);
	DDX_Text(pDX, IDC_EDIT_BMP_SP_SIZE_X, m_bmpSpSizeX);
	DDV_MinMaxInt(pDX, m_bmpSpSizeX, 1, INT_MAX);
	DDX_Text(pDX, IDC_EDIT_BMP_SP_SIZE_Y, m_bmpSpSizeY);
	DDV_MinMaxInt(pDX, m_bmpSpSizeY, 1, INT_MAX);
	DDX_Text(pDX, IDC_EDIT_BMP_SP_FRAME_COUNT, m_bmpSpFrameCount);
	DDV_MinMaxInt(pDX, m_bmpSpFrameCount, 1, INT_MAX);
	DDX_Text(pDX, IDC_EDIT_BMP_SP_READ_TO, m_bmpSpReadTo);
	DDV_MaxChars(pDX, m_bmpSpReadTo, 2);
	DDX_Text(pDX, IDC_EDIT_BMP_SP_READ_OFFSET, m_bmpSpReadOffset);
	DDV_MinMaxInt(pDX, m_bmpSpReadOffset, 0, 255);
	DDX_Text(pDX, IDC_EDIT_BMP_PAL_READ_TO, m_bmpPalReadTo);
	DDV_MinMaxInt(pDX, m_bmpPalReadTo, 0, 15);
	DDX_Text(pDX, IDC_EDIT_BMP_PAL_READ_OFFSET, m_bmpPalReadOffset);
	DDV_MinMaxInt(pDX, m_bmpPalReadOffset, 0, 15);
	DDX_Text(pDX, IDC_EDIT_BMP_PAL_READ_COUNT, m_bmpPalReadCount);
	DDV_MinMaxInt(pDX, m_bmpPalReadCount, 1, 16);
	DDX_Check(pDX, IDC_CHECK_SHIFT_PAL, m_bmpPalShift);
	DDX_Text(pDX, IDC_EDIT_SP_SAVE_SP_FILENAME, m_spSaveSpFilename);
	DDX_Text(pDX, IDC_EDIT_SP_SAVE_SP_FROM, m_spSaveSpFrom);
	DDV_MaxChars(pDX, m_spSaveSpFrom, 2);
	DDX_Text(pDX, IDC_EDIT_SP_SAVE_SP_COUNT, m_spSaveSpCount);
	DDV_MinMaxInt(pDX, m_spSaveSpCount, 1, 256);
	DDX_Text(pDX, IDC_EDIT_SP_SAVE_PAL_FILENAME, m_spSavePalFilename);
	DDX_Text(pDX, IDC_EDIT_SP_SAVE_PAL_FROM, m_spSavePalFrom);
	DDV_MinMaxInt(pDX, m_spSavePalFrom, 0, 15);
	DDX_Text(pDX, IDC_EDIT_SP_SAVE_PAL_COUNT, m_spSavePalCount);
	DDV_MinMaxInt(pDX, m_spSavePalCount, 1, 16);
	DDX_Check(pDX, IDC_AUTOSW, m_bmpSaveAutoSw);
	DDX_Text(pDX, IDC_EDIT_SCRIPT_FILENAME, m_scriptFilename);
}

BEGIN_MESSAGE_MAP(CSpconvDlg, CDialog)
	//{{AFX_MSG_MAP(CSpconvDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_AUTOSW, OnAutosw)
	ON_BN_CLICKED(IDC_SPREF, OnSpref)
	ON_BN_CLICKED(IDC_PALREF, OnPalref)
	ON_BN_CLICKED(IDC_BMPREF, OnBmpref)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_DIRREF, &CSpconvDlg::OnBnClickedDirref)
	ON_BN_CLICKED(IDC_BUTTON_LOADBMP, &CSpconvDlg::OnBnClickedButtonLoadbmp)
	ON_BN_CLICKED(IDC_BUTTON_CONV_TO_SP, &CSpconvDlg::OnBnClickedButtonConvToSp)
	ON_BN_CLICKED(IDC_BUTTON_SP_TO_BMP, &CSpconvDlg::OnBnClickedButtonSpToBmp)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDCANCEL, &CSpconvDlg::OnBnClickedCancel)
	ON_BN_CLICKED(IDC_BUTTON_READ_PAL, &CSpconvDlg::OnBnClickedButtonReadPal)
	ON_BN_CLICKED(IDC_BUTTON_REF_BASEPATH, &CSpconvDlg::OnBnClickedButtonRefBasepath)
	ON_BN_CLICKED(IDC_BUTTON_READ_SP, &CSpconvDlg::OnBnClickedButtonReadSp)
	ON_BN_CLICKED(IDC_BUTTON_BMP_FILENAME_REF, &CSpconvDlg::OnBnClickedButtonBmpFilenameRef)
	ON_BN_CLICKED(IDC_BUTTON_BMP_SP_READ, &CSpconvDlg::OnBnClickedButtonBmpSpRead)
	ON_BN_CLICKED(IDC_BUTTON_SP_SAVE_SP_REF, &CSpconvDlg::OnBnClickedButtonSpSaveSpRef)
	ON_BN_CLICKED(IDC_BUTTON_SP_SAVE_PAL_REF, &CSpconvDlg::OnBnClickedButtonSpSavePalRef)
	ON_BN_CLICKED(IDC_BUTTON_BMP_SAVE_FULLCOLOR_BMP, &CSpconvDlg::OnBnClickedButtonBmpSaveFullcolorBmp)
	ON_BN_CLICKED(IDC_BUTTON_SCRIPT_FILENAME_REF, &CSpconvDlg::OnBnClickedButtonScriptFilenameRef)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_CSV, &CSpconvDlg::OnBnClickedButtonSaveCsv)
	ON_BN_CLICKED(IDC_BUTTON_READ_CSV, &CSpconvDlg::OnBnClickedButtonReadCsv)
	ON_BN_CLICKED(IDC_BUTTON_EXEC_CSV, &CSpconvDlg::OnBnClickedButtonExecCsv)
	ON_EN_KILLFOCUS(IDC_EDIT_CSVLIST, &CSpconvDlg::OnEnKillfocusEditCsvlist)
	ON_BN_CLICKED(IDC_BUTTON_SAVE256, &CSpconvDlg::OnBnClickedButtonSave256)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpconvDlg bZ[W nh

BOOL CSpconvDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// "o[W..." j[ڂVXe j[֒ǉ܂B

	// IDM_ABOUTBOX ̓R}h j[͈̔͂łȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ

	// TODO: ʂȏs͂̏ꏊɒǉĂB
	Initialize();

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

/// <summary>
/// 
/// </summary>
void CSpconvDlg::Initialize()
{
	// f[^荞
	UpdateData(true);
	// JgfBNg擾
	char cdir[260];								// JgfBNg擾
	GetCurrentDirectory(260, cdir);
	
	// <<< l̏ݒ >>>
	//
	// ́FXvCg
	//
	m_spReadTo = CString("00");				// SP̓ǂݍݐIndex
	m_spReadOffset = 0;
	m_spReadCount = 256;
	m_spAssumedPal = 0;
	m_palReadTo = 0;
	m_palReadOffset = 0;
	m_palReadCount = 16;
	//
	// ́FBMP
	// 
	m_bmpBmpFilename = "";
	m_bmpSpSizeX = 1;
	m_bmpSpSizeY = 1;
	m_bmpSpFrameCount = 256;
	m_bmpSpReadTo = "00";
	m_bmpSpReadOffset = 0;
	m_bmpPalReadTo = 0;
	m_bmpPalReadOffset = 0;
	m_bmpPalReadCount = 16;
	m_bmpPalShift = true;

	//
	// óFBMP
	//
	m_DirName = CString(cdir);				// JgfBNg
	m_MainName = CString("sprite.bmp");		// Ct@C

	// IuWFNg̏
	spimage = NULL;										// roC[Waloւ̃|C^
	palimage = NULL;									// o`kC[Waloւ̃|C^
	tximage = NULL;										// eNX`C[WBMPւ̃|C^

	MakeSpImage();										// XvCg̃C[Wrbg}bv̍쐬
	MakePalImage();										// pbg̃C[Wrbg}bv̍쐬
	InitializeTextureImage();									// eNX`̃C[Wrbg}bv̍쐬

	SelectedPalBlock = 0;								// I𒆂̃pbgubN͂O

	// l_CAOɔf
	UpdateData(FALSE);
}

/// <summary>
/// ef[^̉
/// </summary>
void CSpconvDlg::Release()
{
	// 摜
	if (spimage != NULL) {
		delete spimage;
		spimage = NULL;
	}
	if (palimage != NULL) {
		delete palimage;
		palimage = NULL;
	}
	if (tximage != NULL) {
		delete tximage;
		tximage = NULL;
	}
}

void CSpconvDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CSpconvDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM)dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
		DrawScreenAll();					// Ƃ肠AŜĕ`悷֐ցEEE
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CSpconvDlg::OnQueryDragIcon()
{
	return (HCURSOR)m_hIcon;
}

//------------------------------------------------------------------< ϊs̏ >
void CSpconvDlg::OnOK()
{


	//	CDialog::OnOK();
}


//----------------------------------------------------------------------< ʂ̕`Ȃ >
void CSpconvDlg::DrawScreenAll()
{
	// C[W̕\
	CDC* pDC;
	pDC = GetDC();

	spimage->NormalDraw(CPoint(SPIMAGE_X, SPIMAGE_Y), pDC);			// `
	palimage->NormalDraw(CPoint(PALIMAGE_X, PALIMAGE_Y), pDC);		// `
	tximage->NormalDraw(CPoint(TXIMAGE_X, TXIMAGE_Y), pDC);		// `

	{
		CBrush tempbrush;												// IĂpbg͂
		tempbrush.CreateSolidBrush(RGB(255, 255, 255));
		pDC->FrameRect(
			CRect(
				PALIMAGE_X, PALIMAGE_Y + (SelectedPalBlock * 8)
				, PALIMAGE_X + 128, PALIMAGE_Y + (SelectedPalBlock * 8) + 8)
			, &tempbrush);
	}
	ReleaseDC(pDC);													// `I

	char nstr[3];										// pbgubN̔ԍ\
	sprintf(nstr, "%2d", SelectedPalBlock);
	CStatic* no;
	no = (CStatic*)GetDlgItem(IDC_PALBLOCKNO);
	no->SetWindowText(CString(nstr));
}

/// <summary>
/// BMPSPɃp^[]ʂ
/// </summary>
/// <param name="idxFrom"></param>
/// <param name="idxTo"></param>
void CSpconvDlg::TranslateBmpToSp(int idxFrom, int idxTo)
{
	BOOL needToBitOperation = false;
	if (!tximage->isBitOpe()) {
		needToBitOperation = true;
	}

	if (needToBitOperation) {
		tximage->PrepareBitOperation();
	}

	// 摜荞
	for(int idx = idxFrom;idx<=idxTo;idx++) {
		int spY = idx / 16;
		int spX = idx & 15;
		int offX = spX * 16;	// 摜SPp^[sNZʒu
		int offY = spY * 16;

		int pcgIndex = 0;
		// 8hbg
		for (int y = 0; y < 16; y++) {
			for (int x = 0; x < 8; x += 2) {
				BYTE l = tximage->GetPixelIndex(offX + x, offY + y) & 15;
				BYTE r = tximage->GetPixelIndex(offX + x + 1, offY + y) & 15;
				BYTE v = (l << 4) + r;
				sp_data[spY][spX][pcgIndex++] = v;
			}
		}
		// E8hbg
		for (int y = 0; y < 16; y++) {
			for (int x = 8; x < 16; x += 2) {
				BYTE l = tximage->GetPixelIndex(offX + x, offY + y) & 15;
				BYTE r = tximage->GetPixelIndex(offX + x + 1, offY + y) & 15;
				BYTE v = (l << 4) + r;
				sp_data[spY][spX][pcgIndex++] = v;
			}
		}
	}

	if (needToBitOperation) {
		CDC* pDC = GetDC();
		tximage->EndBitOperation(pDC);
		ReleaseDC(pDC);
	}

	// 摜č\z
	MakeSpImage();
}

/// <summary>
/// SPBMPɃp^[]ʂ
/// </summary>
/// <param name="idxFrom"></param>
/// <param name="idxTo"></param>
void CSpconvDlg::TranslateSpToBmp(int idxFrom, int idxTo, int spAssumedPal)
{
	BOOL needToBitOperation = false;
	if (!tximage->isBitOpe()) {
		needToBitOperation = true;
	}

	if (needToBitOperation) {
		tximage->PrepareBitOperation();
	}

	// 摜荞
	for (int idx = idxFrom; idx <= min(idxTo,255); idx++) {
		int spY = idx / 16;
		int spX = idx & 15;
		int offX = spX * 16;	// 摜SPp^[sNZʒu
		int offY = spY * 16;

		for (int y = 0; y < 16; y++) {
			for (int x = 0; x < 16; x++) {
				int code = spimage->GetPixelIndex(offX + x, offY + y);
				int adjustedCode = code + (spAssumedPal * 16);
				if ((adjustedCode < 0) || (adjustedCode >= 256)) {
					adjustedCode = code;
				}
				tximage->SetPixelIndex(offX + x, offY + y, adjustedCode);
			}
		}
	}

	if (needToBitOperation) {
		CDC* pDC = GetDC();
		tximage->EndBitOperation(pDC);
		ReleaseDC(pDC);
	}
}


//------------------------------------------------------< sXCb`NbNꂽꍇ >
void CSpconvDlg::OnAutosw()
{
	CButton* btn;
	btn = (CButton*)GetDlgItem(IDC_AUTOSW);					// XCb`̃IuWFNgւ̃|C^𓾂

	CEdit* bmpedit;								// alot@CGfBbg{bNX
	CEdit* extedit;								// WJfBNgGfBbg{bNX
	CEdit* mainedit;							// t@CGfBbg{bNX
	CButton* bmpref;							// aloQƃ{^
	CButton* extref;							// WJfBNgQƃ{^
	bmpedit = (CEdit*)GetDlgItem(IDC_BMPFILE);			// eRg[̃|C^𓾂
	extedit = (CEdit*)GetDlgItem(IDC_DIRNAME);
	mainedit = (CEdit*)GetDlgItem(IDC_MAINNAME);
	bmpref = (CButton*)GetDlgItem(IDC_BMPREF);
	extref = (CButton*)GetDlgItem(IDC_DIRREF);

	if (btn->GetCheck()) {									// `FbNIɂȂꍇ
		bmpedit->EnableWindow(FALSE);				// t@C̃GfBbg{bNX͎gps\
		extedit->EnableWindow(TRUE);				// WJfBNg̃GfBbg{bNX͎gp\
		mainedit->EnableWindow(TRUE);				// t@C̃GfBbg{bNX͎gp\
		bmpref->EnableWindow(FALSE);				// alo̎QƂ͎gps
		extref->EnableWindow(TRUE);					// WJfBNg̎QƂ͎gp\
	}
	else {												// `FbNItɂȂꍇ
		bmpedit->EnableWindow(TRUE);				// t@C̃GfBbg{bNX͎gps\
		extedit->EnableWindow(FALSE);				// WJfBNg̃GfBbg{bNX͎gp\
		mainedit->EnableWindow(FALSE);				// t@C̃GfBbg{bNX͎gp\
		bmpref->EnableWindow(TRUE);					// alo̎QƂ͎gps
		extref->EnableWindow(FALSE);				// WJfBNg̎QƂ͎gp\
	}

}


//--------------------------------------------------------------------< rot@CQ >
void CSpconvDlg::OnSpref()
{
	CFileDialog dlg(
		TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_NONETWORKBUTTON | OFN_PATHMUSTEXIST, "SPt@C|*.sp|ׂẴt@C|*.*||"
	);

	if (dlg.DoModal() == IDOK) {						// _CAO\
		CString filename;
		filename = dlg.GetPathName();					// t@Cl[擾
		CEdit* spfile;								// GfBbg{bNXւ̃|C^𓾂
		spfile = (CEdit*)GetDlgItem(IDC_SPFILE);
		spfile->SetWindowText(filename);			// t@Cl[GfBbg{bNX֏
	}
}


//---------------------------------------------------------< pbgt@CQ >
void CSpconvDlg::OnPalref()
{
	CFileDialog dlg(
		TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_NONETWORKBUTTON | OFN_PATHMUSTEXIST, "PALt@C|*.pal|ׂẴt@C|*.*||"
	);

	if (dlg.DoModal() == IDOK) {						// _CAO\
		CString filename;
		filename = dlg.GetPathName();					// t@Cl[擾
		CEdit* palfile;								// GfBbg{bNXւ̃|C^𓾂
		palfile = (CEdit*)GetDlgItem(IDC_PALFILE);
		palfile->SetWindowText(filename);			// t@Cl[GfBbg{bNX֏
	}
}


//---------------------------------------------------------< alot@CQ >
void CSpconvDlg::OnBmpref()
{
	CFileDialog dlg(
		FALSE, "bmp", NULL, OFN_HIDEREADONLY | OFN_NONETWORKBUTTON | OFN_PATHMUSTEXIST, "BMPt@C|*.bmp||"
	);

	if (dlg.DoModal() == IDOK) {						// _CAO\
		CString filename;
		filename = dlg.GetPathName();					// t@Cl[擾
		CEdit* bmpfile;								// GfBbg{bNXւ̃|C^𓾂
		bmpfile = (CEdit*)GetDlgItem(IDC_BMPFILE);
		bmpfile->SetWindowText(filename);			// t@Cl[GfBbg{bNX֏
	}
}


//---------------------------------------------------------< WJfBNgQ >
void CSpconvDlg::OnBnClickedDirref()
{
	/*
	CDirSelectDialog dlg;

	CString temp;
	GetDlgItemText(IDC_DIRNAME, temp);
	dlg.InitialDirectory = temp;
	if (dlg.DoModal() == IDOK) {				// _CAO\
		CEdit* dirname;								// GfBbg{bNXւ̃|C^𓾂
		dirname = (CEdit*)GetDlgItem(IDC_DIRNAME);
		dirname->SetWindowText(dlg.SelectedPath);	// t@Cl[GfBbg{bNX֏
	}
	*/

	UpdateData();
	CFolderPickerDialog folderDialog(m_DirName);

	// _CAO\
	if (folderDialog.DoModal() == IDOK)
	{
		CString fullPathName = folderDialog.GetPathName();
		m_DirName = fullPathName;
		UpdateData(FALSE);
	}
}


//--------------------------------------------------------------<qfae[u>
void CSpconvDlg::MakeRGBTable()
{
	union {
		WORD mixed;
		struct {
			unsigned dummy : 1;
			unsigned blue : 5;
			unsigned red : 5;
			unsigned green : 5;
		}bit;
	}map;
	int i, c, d;

	for (i = 0; i < 16; i++) {
		for (c = 0; c < 16; c++) {
			d = pal_data[i][c] & 255;									// rv`op
			map.mixed = ((pal_data[i][c] >> 8) & 255) + ((d << 8) & 0xFF00);	// l荞
			rgb_data[i][c].rgbRed = (map.bit.red * 255) / 31;			// ϊ
			rgb_data[i][c].rgbGreen = (map.bit.green * 255) / 31;
			rgb_data[i][c].rgbBlue = (map.bit.blue * 255) / 31;
		}
	}
}


//------------------------------------------------------------------< ro̕\C[W >
void CSpconvDlg::MakeSpImage()
{
	int i, c, d;

	if (spimage != NULL) {				// łɂaloZbgĂA܂
		delete spimage;
	}

	// C[W쐬̕
	CDC* pDC, memDC;									// foCXReLXgp
	pDC = GetDC();									// 擾
	spimage = new Cfbmp(256, 256, 4, pDC);				// PUFCfbmpIuWFNg쐬
	CFont tempfont;									// tHg
	tempfont.CreateFont(16, 0, 0, 0, FW_NORMAL, 0, 0, 0
		, SHIFTJIS_CHARSET, OUT_DEVICE_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY
		, DEFAULT_PITCH, "System");
	memDC.CreateCompatibleDC(pDC);					// Rp`
	pDC->TextOut(SPIMAGE_X + 5, SPIMAGE_Y + 5, CString("C[W쐬..."));

	// `
	spimage->PrepareBitOperation();
	for (i = 0; i < 16; i++)spimage->SetPalet(i, rgb_data[SelectedPalBlock][i]);	// pbgKp
	for (int y = 0; y < 256; y++) {						// o͉摜Oŏ
		for (int x = 0; x < 256; x++) {
			spimage->SetPixelIndex(x, y, 0);
		}
	}
	int IndexArray[256 * 256];							// CfbNX̃}bvۑ
	for (i = 0; i < 16; i++) {
		for (c = 0; c < 16; c++) {
			for (d = 0; d < 128; d++) {
				int offset_x, offset_y;
				if (d < 64) {						// ItZbgݒ(PP;
					offset_x = 0;
					offset_y = 0;
				}
				else {
					offset_x = 8;
					offset_y = -16;
				}
				//
				IndexArray[(((i * 16) + ((d * 2) / 8) + offset_y) * 256) + ((c * 16) + offset_x + (((d * 2)) & 7))] = (sp_data[i][c][d] >> 4) & 15;
				IndexArray[(((i * 16) + ((d * 2) / 8) + offset_y) * 256) + ((c * 16) + offset_x + (((d * 2) + 1) & 7))] = sp_data[i][c][d] & 15;
			}
		}
	}
	for (i = 0; i < 256; i++) {
		for (c = 0; c < 256; c++) {
			int index;
			index = spimage->SetPixelIndex(c, i, IndexArray[(i * 256) + c]);
		}
	}
	spimage->EndBitOperation(pDC);

	ReleaseDC(pDC);									// cbďI

	return;
}


//------------------------------------------------------------------< o`k̕\C[W >
void CSpconvDlg::MakePalImage()
{
	int i, c;
	if (palimage != NULL) {
		delete palimage;
	}

	CDC* pDC, memDC;									// foCXReLXgp
	pDC = GetDC();									// 擾
	palimage = new Cfbmp(128, 128, 24, pDC);			// rbg}bvIuWFNg쐬
	CFont tempfont;									// tHg
	tempfont.CreateFont(16, 0, 0, 0, FW_NORMAL, 0, 0, 0
		, SHIFTJIS_CHARSET, OUT_DEVICE_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY
		, DEFAULT_PITCH, "System");
	memDC.CreateCompatibleDC(pDC);					// Rp`

	/*
	if(isPalSet == FALSE){					// o`k̃f[^ZbgĂȂꍇ
		CBitmap *tmpbmp=CBitmap::FromHandle(palimage->GetBmpHandle());	// ꎞICBitmapIuWFNg쐬
		CBitmap *oldbmp;								// Âaloۑ
		oldbmp=memDC.SelectObject(tmpbmp);				// roC[WaloI
		CFont *oldfont;									// ÂtHgۑ
		oldfont=memDC.SelectObject(&tempfont);			// tHgI
		int oldbm;										// Â߃[hۑ
		oldbm=memDC.SetBkMode(TRANSPARENT);				// ߃[hZbg
		COLORREF oldcolor;								// ÂIFۑ
		oldcolor=memDC.SetTextColor(RGB(255,255,255));	// FI

											// `
		memDC.FillSolidRect(CRect(0,0,128,128),RGB(0,0,0));
		memDC.TextOut(18,56,CString("- No Image -"));

		memDC.SetTextColor(oldcolor);					// F߂
		memDC.SetBkMode(oldbm);							// ߃[h߂
		memDC.SelectObject(oldfont);					// tHg߂
		memDC.SelectObject(oldbmp);						// alo߂
		ReleaseDC(pDC);									// cbďI

		isPalBmpReady = TRUE;							// 
		return;
	}
	*/


	// f[^Ăꍇ
	CBitmap* tmpbmp = CBitmap::FromHandle(palimage->GetBmpHandle());	// ꎞICBitmapIuWFNg쐬
	CBitmap* oldbmp;								// Âaloۑ
	oldbmp = memDC.SelectObject(tmpbmp);				// o`kC[WaloI

	// `
	memDC.FillSolidRect(CRect(0, 0, 128, 128), RGB(0, 0, 0));
	for (i = 0; i < 16; i++) {
		for (c = 0; c < 16; c++) {
			memDC.FillSolidRect(CRect(c * 8, i * 8, (c * 8) + 7, (i * 8) + 7),
				RGB(rgb_data[i][c].rgbRed,
					rgb_data[i][c].rgbGreen,
					rgb_data[i][c].rgbBlue)
			);
		}
	}

	memDC.SelectObject(oldbmp);						// alo߂
	ReleaseDC(pDC);									// cbďI

	return;
}


/// <summary>
/// eNX`摜
/// </summary>
void CSpconvDlg::InitializeTextureImage()
{
	if (tximage != NULL) {
		delete tximage;
	}

	CDC* pDC = GetDC();								// 擾
	tximage = new Cfbmp(256, 256, 8, pDC);			// 256FCfbmpIuWFNg쐬
	ReleaseDC(pDC);									// cbďI

	return;
}


/// <summary>
/// eNX`摜̃pbgč\z
/// </summary>
void CSpconvDlg::MakeTexturePalet()
{
	// 摜ȂΖ
	if (tximage == NULL) {
		return;
	}

	CDC* pDC = GetDC();									// 擾

	// `
	tximage->PrepareBitOperation();
		// pbgŜ]
	for (int i = 0; i < 16; i++) {
		for (int c = 0; c < 16; c++) {
			tximage->SetPalet((i * 16) + c, rgb_data[i][c]);
		}
	}
	tximage->EndBitOperation(pDC);

	ReleaseDC(pDC);									// cbďI

	return;
}

/// <summary>
/// CSVꗗč\z
/// </summary>
void CSpconvDlg::MakeCsvList()
{
	// x[XpX\𑊑΃pXɕύX
	m_csvList = "";
	for (int i = 0; i < m_operationCsv.GetSize(); i++) {
		m_operationCsv[i].AdjustBasePath(m_scriptBasePath);
		m_csvList.Append(m_operationCsv[i].GetCsvLine());
		m_csvList.Append("\r\n");
	}
	UpdateData(false);
}

/// <summary>
/// SẴC[Wč\z
/// </summary>
void CSpconvDlg::MakeAllImages()
{
	MakeRGBTable();
	MakeSpImage();
	MakePalImage();
	MakeTexturePalet();
	MakeCsvList();
}


//----------------------------------------------------------< NA{^ꂽ >
void CSpconvDlg::OnClear()
{
	int i, c, d;

	// SP, PALNA
	for (i = 0; i < 16; i++) {
		for (c = 0; c < 16; c++) {
			pal_data[i][c] = 0;					// o`kf[^NA
			for (d = 0; d < 128; d++) {
				sp_data[i][c][d] = 0;			// rof[^NA
			}
		}
	}

	// CSVNA
	//m_operationCsv.RemoveAll();

	// BMP
	if (spimage != NULL) {								// C[Waloj
		delete spimage;
		spimage = NULL;
	}
	if (palimage != NULL) {
		delete palimage;
		palimage = NULL;
	}
	if (tximage != NULL) {
		delete tximage;
		tximage = NULL;
	}
	InitializeTextureImage();

	// ʂč\z
	MakeAllImages();
	SelectedPalBlock = 0;						// I𒆂̃pbgubN͂O
	DrawScreenAll();
}


//---------------------------------------------------< tH[ōNbNꂽ >
void CSpconvDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
	if ((point.x >= PALIMAGE_X) && (point.x < PALIMAGE_X + 128)) {		// pbgC[Wゾꍇ
		if ((point.y >= PALIMAGE_Y) && (point.y < PALIMAGE_Y + 128)) {
			int tempblock;
			tempblock = (point.y - PALIMAGE_Y) / 8;				// IĂpbgύX
			if (tempblock == SelectedPalBlock)return;
			SelectedPalBlock = tempblock;
			MakeSpImage();									// G`
			DrawScreenAll();								// Ŝ`
		}
	}

	CDialog::OnLButtonDown(nFlags, point);
}


//-----------------------------------------------------------< alot@Co͂ >
void CSpconvDlg::SaveBmp(CString fname, BOOL indexedColor)
{
	CString fname_main = fname.Left(fname.GetLength() - 4);
	CString fname_a = fname_main + "_a.bmp";

	BOOL bRes = FALSE;
	if (indexedColor) {
		bRes = doSave256((LPCTSTR)fname, spimage);
	}
	else {
		bRes = doSave((LPCTSTR)fname, spimage);
		bRes &= doSaveStencil((LPCTSTR)fname_a, spimage);
	}
	if (bRes == FALSE) {
		MessageBox("BMPt@C̕ۑɎs܂B", "Error", MB_OK);
		return;
	}

	return;											// I
}

BOOL CSpconvDlg::doSave(LPCTSTR fname, Cfbmp* pBmp) {
	if (pBmp->isReady() == FALSE)return FALSE;				// 摜łĂȂ΃G[

	FILE* stream;									// t@CXg[
	stream = fopen(fname, "wb");					// t@CI[v
	if (stream == NULL)return FALSE;				// I[vłȂꍇ

	// rbgz̃TCYvZ
	UINT uSizeImage;
	uSizeImage = (pBmp->GetWidth() * 32) / 8;	// oCgi32bitŒj
	uSizeImage += (4 - (uSizeImage & 3)) & 3;		// SoCgE
	uSizeImage *= pBmp->GetHeight();				// đŜ̃TCY

	// Bitmap File Header 쐬
	//UINT nColors = 1 << 32;
	UINT QuadSize = 0;

	BITMAPFILEHEADER bmfh;
	memset(&bmfh, 0, sizeof(BITMAPFILEHEADER));
	bmfh.bfType = 0x4d42;
	bmfh.bfSize = sizeof(BITMAPV4HEADER) + sizeof(BITMAPFILEHEADER) + QuadSize + uSizeImage;
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = sizeof(BITMAPV4HEADER) + sizeof(BITMAPFILEHEADER) + QuadSize;

	// Bitmap V4 Header 쐬 >>
	BITMAPV4HEADER bmih;
	memset(&bmih, 0, sizeof(BITMAPV4HEADER));
	bmih.bV4Size = sizeof(BITMAPV4HEADER);
	bmih.bV4Width = pBmp->GetWidth();
	bmih.bV4Height = pBmp->GetHeight();
	bmih.bV4Planes = 1;
	bmih.bV4BitCount = 32;
	bmih.bV4V4Compression = BI_BITFIELDS;
	bmih.bV4SizeImage = 0;
	bmih.bV4XPelsPerMeter = 0;
	bmih.bV4YPelsPerMeter = 0;
	bmih.bV4ClrUsed = 0;
	bmih.bV4ClrImportant = 0;
	bmih.bV4RedMask = 0x000000FF;
	bmih.bV4GreenMask = 0x0000FF00;
	bmih.bV4BlueMask = 0x00FF0000;
	bmih.bV4AlphaMask = 0xFF000000;
	bmih.bV4CSType = LCS_sRGB;
	//bmih.bV4Endpoints = xx;	N/A
	bmih.bV4GammaRed = 0;
	bmih.bV4GammaGreen = 0;
	bmih.bV4GammaBlue = 0;

	// 
	fwrite(&bmfh, sizeof(BITMAPFILEHEADER), 1, stream);	// BITMAPFILEHEADER
	fwrite(&bmih, sizeof(BITMAPV4HEADER), 1, stream);	// BITMAPV4HEADER

	//int SizeImage;														// rbgz̃TCYvZ
	for (int y = pBmp->GetHeight() - 1; y >= 0; y--) {
		for (int x = 0; x < pBmp->GetWidth(); x++) {
			int palIndex = pBmp->GetPixelIndex(x, y);
			RGBQUAD quad = pBmp->GetPixelColor(x, y);

			fputc(quad.rgbRed & 0xFF, stream);
			fputc(quad.rgbGreen & 0xFF, stream);
			fputc(quad.rgbBlue & 0xFF, stream);
			fputc(((palIndex&15) == 0 ? 0x00 : 0xFF), stream);
		}
	}

	fclose(stream);												// t@CN[Y

	return TRUE;
}

BOOL CSpconvDlg::doSaveStencil(LPCTSTR fname, Cfbmp* pBmp) {
	if (pBmp->isReady() == FALSE)return FALSE;				// 摜łĂȂ΃G[

	FILE* stream;									// t@CXg[
	stream = fopen(fname, "wb");					// t@CI[v
	if (stream == NULL)return FALSE;				// I[vłȂꍇ

	// rbgz̃TCYvZ
	UINT uSizeImage;
	uSizeImage = (pBmp->GetWidth() * 32) / 8;	// oCgi32bitŒj
	uSizeImage += (4 - (uSizeImage & 3)) & 3;		// SoCgE
	uSizeImage *= pBmp->GetHeight();				// đŜ̃TCY

	// Bitmap File Header 쐬
	//UINT nColors = 1 << 32;
	UINT QuadSize = 0;

	BITMAPFILEHEADER bmfh;
	memset(&bmfh, 0, sizeof(BITMAPFILEHEADER));
	bmfh.bfType = 0x4d42;
	bmfh.bfSize = sizeof(BITMAPV4HEADER) + sizeof(BITMAPFILEHEADER) + QuadSize + uSizeImage;
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = sizeof(BITMAPV4HEADER) + sizeof(BITMAPFILEHEADER) + QuadSize;

	// Bitmap V4 Header 쐬 >>
	BITMAPV4HEADER bmih;
	memset(&bmih, 0, sizeof(BITMAPV4HEADER));
	bmih.bV4Size = sizeof(BITMAPV4HEADER);
	bmih.bV4Width = pBmp->GetWidth();
	bmih.bV4Height = pBmp->GetHeight();
	bmih.bV4Planes = 1;
	bmih.bV4BitCount = 32;
	bmih.bV4V4Compression = BI_BITFIELDS;
	bmih.bV4SizeImage = 0;
	bmih.bV4XPelsPerMeter = 0;
	bmih.bV4YPelsPerMeter = 0;
	bmih.bV4ClrUsed = 0;
	bmih.bV4ClrImportant = 0;
	bmih.bV4RedMask = 0x000000FF;
	bmih.bV4GreenMask = 0x0000FF00;
	bmih.bV4BlueMask = 0x00FF0000;
	bmih.bV4AlphaMask = 0xFF000000;
	bmih.bV4CSType = LCS_sRGB;
	//bmih.bV4Endpoints = xx;	N/A
	bmih.bV4GammaRed = 0;
	bmih.bV4GammaGreen = 0;
	bmih.bV4GammaBlue = 0;

	// 
	fwrite(&bmfh, sizeof(BITMAPFILEHEADER), 1, stream);	// BITMAPFILEHEADER
	fwrite(&bmih, sizeof(BITMAPV4HEADER), 1, stream);	// BITMAPV4HEADER

	//int SizeImage;														// rbgz̃TCYvZ
	for (int y = pBmp->GetHeight() - 1; y >= 0; y--) {
		for (int x = 0; x < pBmp->GetWidth(); x++) {
			int palIndex = pBmp->GetPixelIndex(x, y);
			RGBQUAD quad = pBmp->GetPixelColor(x, y);

			if ((palIndex & 15) == 0) {
				fputc(0x00, stream);
				fputc(0x00, stream);
				fputc(0x00, stream);
				fputc(0xFF, stream);
			}
			else {
				fputc(0xFF, stream);
				fputc(0xFF, stream);
				fputc(0xFF, stream);
				fputc(0xFF, stream);
			}
		}
	}

	fclose(stream);												// t@CN[Y

	return TRUE;
}

BOOL CSpconvDlg::doSave256(LPCTSTR fname, Cfbmp* pBmp) {
	if (pBmp->isReady() == FALSE)return FALSE;				// 摜łĂȂ΃G[
	BOOL res = pBmp->Save(fname);
	return res;
}


//-----------------------------------------------------------------< tpX >
CString CSpconvDlg::MakeFullPathName(CString& dirname, CString& fname)
{
	int i;
	int length1, length2, length;
	length1 = dirname.GetLength();			// fBNg̒
	length2 = fname.GetLength();			// t@C̒
	length = length1 + length2 + 1;			// tpX̒̍ő

	unsigned char* full, * work;				// tpXi[
	full = (unsigned char*)malloc(length + 1);
	work = full;							// Ɨp|C^

	for (int i = 0; i < length1; i++) {				// fBNg̃Rs[
		*work++ = dirname[i];				// PRs[ăCNg
	}
	while (1) {								// Ō̕ \ ALZ
		if ((length1 == 1) && (*(work - 1) == '\\')) {	// PŁ
			work--;
			break;
		}
		if ((*(work - 1) == '\\') && (*(work - 2) < 0x80) && (length1 >= 2)) {	// QȏŁŃ}`oCgȂ
			work--;
			length1 -= 1;
		}
		else break;
	}
	*work++ = '\\';							// ؂

	for (i = 0; i < length2; i++) {					// t@C̃Rs[
		*work++ = fname[i];
	}
	*work++ = 0;							// GhR[h

	CString res(full);
	free(full);
	return res;								// Ԃ
}

/// <summary>
/// SP, PALۑ
/// </summary>
void CSpconvDlg::OnBnClickedButtonConvToSp()
{
	UpdateData();

	// t@CwLmF
	if (m_spSaveSpFilename.GetLength() == 0) {
		MessageBox("SPt@C̏o͐悪w肳Ă܂B");
		return;
	}
	if (m_spSavePalFilename.GetLength() == 0) {
		MessageBox("PALt@C̏o͐悪w肳Ă܂B");
		return;
	}

	// t@CmF
	CFileStatus spFileStatus;
	CFileStatus palFileStatus;
	BOOL spFileExists = CFile::GetStatus(m_spSaveSpFilename, spFileStatus);
	BOOL palFileExists = CFile::GetStatus(m_spSavePalFilename, palFileStatus);
	CString existingFile = "";
	if (spFileExists) { existingFile += CString(m_spSaveSpFilename); }
	if (palFileExists) {
		if (existingFile.GetLength() > 0) {
			existingFile += CString(", ");
		}
		existingFile += CString(m_spSavePalFilename);
	}
	if (spFileExists || palFileExists) {
		CString msg = existingFile + CString("͊łB㏑܂H");
		int mbRes = MessageBox(msg, "mF", MB_YESNO);
		if (mbRes != IDYES) {
			// LZ
			return;
		}
	}

	// SP̐擪AhXƌm肳
	int spSaveSpFromDec = 0;
	int parseResult = sscanf(m_spSaveSpFrom, "%02X", &spSaveSpFromDec);
	if (parseResult <= 0) {
		MessageBox("擪Index216iŎw肵ĂB");
		return;
	}

	CRes res = ExecSaveSpPal(m_spSaveSpFilename, spSaveSpFromDec, m_spSaveSpCount
		, m_spSavePalFilename, m_spSavePalFrom, m_spSavePalCount, m_scriptBasePath);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// CSVɃIy[Vǉ
	CsvEntry entry(CSVCMD_SAVE_SP_PAL);
	entry.AddParam(m_spSaveSpFilename, true);
	entry.AddParam(m_spSaveSpFrom, true);
	entry.AddParam(m_spSaveSpCount);
	entry.AddParam(m_spSavePalFilename, true);
	entry.AddParam(m_spSavePalFrom);
	entry.AddParam(m_spSavePalCount);
	m_operationCsv.Add(entry);

	// IbZ[W
	MessageBox("SP, PALۑ܂B");

	// ĕ`
	MakeAllImages();
	DrawScreenAll();
}

/// <summary>
/// BMPۑ{^
/// </summary>
void CSpconvDlg::OnBnClickedButtonSpToBmp()
{
	UpdateData(TRUE);									// f[^oϐ֎荞

	// t@CmF
	if (!m_bmpSaveAutoSw) {
		CFileStatus fileStatus;
		BOOL fileExists = CFile::GetStatus(m_BmpFile, fileStatus);
		if (fileExists) {
			CString msg = m_BmpFile + CString("͊łB㏑܂H");
			int mbRes = MessageBox(msg, "mF", MB_YESNO);
			if (mbRes != IDYES) {
				// LZ
				return;
			}
		}
	}

	if (m_bmpSaveAutoSw) {				//--------- I[g̏ꍇ
		if (m_DirName == "") {
			MessageBox("o͂̓WJfBNgw肳Ă܂");
			return;
		}
		if (m_MainName == "") {
			MessageBox("o͂alot@C̎t@Cw肳Ă܂");
			return;
		}
	}
	else {							//------------ I[gȂꍇ
		if (m_BmpFile == "") {
			MessageBox("o͂BMPt@Cw肳Ă܂");
			return;
		}
	}

	CRes res = ExecSaveBmpCnv(m_BmpFile, m_DirName, m_MainName, m_bmpSaveAutoSw, m_scriptBasePath, FALSE, SelectedPalBlock);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// CSVɃIy[Vǉ
	CsvEntry entry(CSVCMD_SAVE_BMP_CNV);
	entry.AddParam(m_BmpFile, true);
	entry.AddParam(m_DirName, true);
	entry.AddParam(m_MainName, true);
	entry.AddParamBool(m_bmpSaveAutoSw);
	entry.AddParam(SelectedPalBlock);
	m_operationCsv.Add(entry);

	// ʍĕ`
	MakeAllImages();
	DrawScreenAll();

	// IbZ[W
	MessageBox("BMPt@Cۑ܂B");
}

/// <summary>
/// ~{^Ƃ̃Cxgnh
/// </summary>
void CSpconvDlg::OnClose()
{
	Release();
	CDialog::OnClose();
}

/// <summary>
/// {^Ƃ̃Cxgnh
/// </summary>
void CSpconvDlg::OnBnClickedCancel()
{
	Release();
	CDialog::OnCancel();
}

/// <summary>
/// PALǂݍ݃{^Ƃ̃Cxgnh
/// </summary>
void CSpconvDlg::OnBnClickedButtonReadPal()
{
	// f[^荞
	UpdateData();

	// l`FbN
	if (m_PalFile.GetLength() == 0) {
		MessageBox("pbgt@Cw肳Ă܂", "Error", MB_OK);
		return;
	}
	if ((m_palReadTo < 0) || (m_palReadTo > 16)) {
		CString message;
		message.Format("pbg̓ǂݍݐ̃ubNԍsłBBlock=[%d]", m_palReadTo);
		MessageBox(message, "Error", MB_OK);
		return;
	}
	if ((m_palReadTo + m_palReadCount) > 16) {
		m_palReadCount = 16 - m_palReadTo;
	}

	CRes res = ExecReadPalet(m_PalFile, m_palReadTo, m_palReadOffset, m_palReadCount, m_scriptBasePath);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// CSVɃIy[Vǉ
	CsvEntry entry(CSVCMD_READ_PALET);
	entry.AddParam(m_PalFile, true);
	entry.AddParam(m_palReadTo);
	entry.AddParam(m_palReadOffset);
	entry.AddParam(m_palReadCount);
	m_operationCsv.Add(entry);

	// 摜č\zčĕ`悷
	SelectedPalBlock = 0;					// I𒆂̃pbgubN͂O
	MakeAllImages();						// ׂẲ摜č\z
	DrawScreenAll();										// ĕ`

	// lʂɔf
	UpdateData(false);
}

/*
//-------------------------------------------< roAo`kt@Cǂݍ݁Aʂɔf >
void CSpconvDlg::OnView()
{
	int i, c, d;

	UpdateData();											// _CAO̕\eoϐ֊i[
	for (i = 0; i < 16; i++) {
		for (c = 0; c < 16; c++) {
			pal_data[i][c] = 0;					// o`kf[^NA
			for (d = 0; d < 128; d++) {
				sp_data[i][c][d] = 0;			// rof[^NA
			}
		}
	}
	MakeSpImage();
	MakePalImage();
	DrawScreenAll();							// xʂŏ

	FILE* stream;											// t@CXg[
	int res;												// ʕێ
	char tempstring[1024];									// \p̃obt@
	// roǂݍ݁
	if (m_SpFile.GetLength() == 0) {							// t@Cw肳ĂȂ
		MessageBox("rot@Cw肳Ă܂", "Error", MB_OK);
		MakeSpImage();										// roC[W
		return;
	}
	stream = fopen((LPCTSTR)m_SpFile, "rb");							// rot@CI[v
	if (stream == 0) {											// I[vs̏ꍇ
		sprintf(tempstring, "[%s]J܂ł", (LPCTSTR)m_SpFile);
		MessageBox(tempstring, MB_OK);
		MakeSpImage();										// roC[W
		return;
	}
	res = (int)fread(sp_data, (16 * 16) / 2, 256, stream);				// f[^̓ǂݍ
	fclose(stream);
	MakeSpImage();										// roC[W

	// o`kǂݍ݁
	if (m_PalFile.GetLength() == 0) {
		MessageBox("pbgt@Cw肳Ă܂", "Error", MB_OK);
		MakePalImage();										// pbgC[W
		return;
	}
	stream = fopen((LPCTSTR)m_PalFile, "rb");							// o`kt@CI[v
	if (stream == 0) {											// I[vs̏ꍇ
		sprintf(tempstring, "[%s]͊J܂ł", (LPCTSTR)m_PalFile);
		MessageBox(tempstring, "Error", MB_OK);
		MakePalImage();										// pbgC[W
		return;
	}
	res = (int)fread(pal_data, 16 * 2, 16, stream);						// f[^̓ǂݍ
	fclose(stream);
	MakeRGBTable();							// o`kf[^qfae[u쐬

	SelectedPalBlock = 0;					// I𒆂̃pbgubN͂O
	MakeSpImage();							// roC[W
	MakePalImage();							// pbgC[W
	DrawScreenAll();										// ĕ`
}
*/

/// <summary>
/// x[XpX̎Qƃ{^̃Cxgnh
/// </summary>
void CSpconvDlg::OnBnClickedButtonRefBasepath()
{
	UpdateData();
	CFolderPickerDialog folderDialog(m_scriptBasePath);

	// _CAO\
	if (folderDialog.DoModal() == IDOK)
	{
		CString fullPathName = folderDialog.GetPathName();
		m_scriptBasePath = fullPathName;
		UpdateData(FALSE);

		// ĕ\
		MakeCsvList();
	}
}

/// <summary>
/// ́FSP XvCgǂݍ
/// </summary>
void CSpconvDlg::OnBnClickedButtonReadSp()
{
	// l荞
	UpdateData();

	// mF
	if (m_SpFile.GetLength() == 0) {							// t@Cw肳ĂȂ
		MessageBox("rot@Cw肳Ă܂", "Error", MB_OK);
		return;
	}
	unsigned int spReadToDec = 0;
	m_spReadTo.MakeUpper();
	int count= sscanf((LPCTSTR)m_spReadTo, "%02X", &spReadToDec);
	if (count <= 0) {
		MessageBox("Ǎ16iŎw肵ĂB");
		return;
	}
	if ((spReadToDec < 0) || (spReadToDec >= 256)) {
		MessageBox("Ǎ0`FF͈̔͂Ŏw肵ĂB");
		return;
	}
	if ((m_spReadOffset < 0) || (m_spReadOffset >= 256)) {
		MessageBox("ǍOffset0`255͈̔͂Ŏw肵ĂB");
		return;
	}
	if ((m_spAssumedPal < 0) || (m_spAssumedPal >= 16)) {
		MessageBox("Pal0`15͈̔͂Ŏw肵ĂB");
		return;
	}
	if ((m_spReadCount < 1) || (m_spReadCount > 256)) {
		MessageBox("1`256͈̔͂Ŏw肵ĂB");
		return;
	}

	// SPǂݍ݂s
	CRes res = ExecReadSp(m_SpFile, spReadToDec, m_spReadOffset, m_spReadCount, m_spAssumedPal, m_scriptBasePath);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// CSVɃIy[Vǉ
	CsvEntry entry(CSVCMD_READ_SP);
	entry.AddParam(m_SpFile, true);
	entry.AddParam(m_spReadTo, true);
	entry.AddParam(m_spReadOffset);
	entry.AddParam(m_spReadCount);
	entry.AddParam(m_spAssumedPal);
	m_operationCsv.Add(entry);

	// `悷
	MakeAllImages();		// ׂẲ摜č\z
	DrawScreenAll();		// ĕ`
}

/// <summary>
/// SP`BMPɕϊ]܂
/// </summary>
/// <param name="spDefIndex"></param>
void CSpconvDlg::SpToBmp(int spDefIndex, int palIndex)
{
	// pbgŜ]
	MakeTexturePalet();

	// p^[]L
	int indexX = spDefIndex & 15;
	int indexY = spDefIndex / 16;
	int px = indexX * 16;
	int py = indexY * 16;

	CDC* pDC = GetDC();
	tximage->PrepareBitOperation();
	for (int y = 0; y < 16; y++) {
		for (int x = 0; x < 16; x++) {
			int code = spimage->GetPixelIndex(px + x, py + y);
			if (code != 0) {
				int a = 1;
			}
			int code256 = palIndex * 16 + code;
			tximage->SetPixelIndex(px + x, py + y, code256);
		}
	}
	tximage->EndBitOperation(pDC);
}

/// <summary>
/// BMPFrbg}bvt@C̎Q
/// </summary>
void CSpconvDlg::OnBnClickedButtonBmpFilenameRef()
{
	UpdateData(true);

	CFileDialog dlg(
		FALSE, "bmp", m_bmpBmpFilename, OFN_HIDEREADONLY | OFN_NONETWORKBUTTON | OFN_PATHMUSTEXIST, "BMPt@C|*.bmp||"
	);
	if (dlg.DoModal() != IDOK) {						// _CAO\
		return;
	}

	// OKꂽ̏
	m_bmpBmpFilename = dlg.GetPathName();					// t@Cl[擾
	UpdateData(false);
}

/// <summary>
/// BMPFSPǂݍ
/// </summary>
void CSpconvDlg::OnBnClickedButtonBmpSpRead()
{
	UpdateData();

	int bmpSpReadToDec = 0;
	int scanCount = sscanf(m_bmpSpReadTo, "%02X", &bmpSpReadToDec);
	if (scanCount <= 0) {
		MessageBox("ǂݍݐ16i2œ͂ĂB");
		return;
	}

	CRes res = ExecReadBmpSp(m_bmpBmpFilename, m_bmpSpSizeX, m_bmpSpSizeY
		, m_bmpSpFrameCount, bmpSpReadToDec, m_bmpSpReadOffset
		, m_bmpPalReadTo, m_bmpPalReadOffset, m_bmpPalReadCount
		, m_bmpPalShift, m_scriptBasePath
	);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// CSVɃIy[Vǉ
	CsvEntry entry(CSVCMD_READ_BMP_SP);
	entry.AddParam(m_bmpBmpFilename, true);
	entry.AddParam(m_bmpSpSizeX);
	entry.AddParam(m_bmpSpSizeY);
	entry.AddParam(m_bmpSpFrameCount);
	entry.AddParam(m_bmpSpReadTo, true);
	entry.AddParam(m_bmpSpReadOffset);
	entry.AddParam(m_bmpPalReadTo);
	entry.AddParam(m_bmpPalReadOffset);
	entry.AddParam(m_bmpPalReadCount);
	entry.AddParamBool(m_bmpPalShift);
	m_operationCsv.Add(entry);

	// ʍĕ`
	MakeAllImages();
	DrawScreenAll();
}

/// <summary>
/// BMPFPalǂݍ
/// </summary>
void CSpconvDlg::OnBnClickedButtonLoadbmp()
{
	UpdateData();

	CRes res = ExecReadBmpPal(m_bmpBmpFilename, m_bmpPalReadTo, m_bmpPalReadOffset, m_bmpPalReadCount, m_scriptBasePath);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// CSVɃIy[Vǉ
	CsvEntry entry(CSVCMD_READ_BMP_PAL);
	entry.AddParam(m_bmpBmpFilename, true);
	entry.AddParam(m_bmpPalReadTo);
	entry.AddParam(m_bmpPalReadOffset);
	entry.AddParam(m_bmpPalReadCount);
	m_operationCsv.Add(entry);

	// ʍĕ`
	MakeAllImages();
	DrawScreenAll();
}

/// <summary>
/// SPۑt@C̎w
/// </summary>
void CSpconvDlg::OnBnClickedButtonSpSaveSpRef()
{
	UpdateData();

	CFileDialog dlg(
		FALSE, "sp", m_spSaveSpFilename, OFN_HIDEREADONLY | OFN_NONETWORKBUTTON | OFN_PATHMUSTEXIST, "SPt@C|*.sp||"
	);

	if (dlg.DoModal() != IDOK) {						// _CAO\
		return;
	}

	m_spSaveSpFilename = dlg.GetPathName();				// t@Cl[擾

	UpdateData(false);
}

/// <summary>
/// PALۑt@C̎w
/// </summary>
void CSpconvDlg::OnBnClickedButtonSpSavePalRef()
{
	UpdateData();

	CFileDialog dlg(
		FALSE, "pal", m_spSavePalFilename, OFN_HIDEREADONLY | OFN_NONETWORKBUTTON | OFN_PATHMUSTEXIST, "PALt@C|*.pal||"
	);

	if (dlg.DoModal() != IDOK) {						// _CAO\
		return;
	}

	m_spSavePalFilename = dlg.GetPathName();				// t@Cl[擾

	UpdateData(false);
}


/// <summary>
/// BMPۑ
/// </summary>
void CSpconvDlg::OnBnClickedButtonBmpSaveFullcolorBmp()
{
	UpdateData(TRUE);									// f[^oϐ֎荞

	if (m_BmpFile.GetLength() <= 0) {
		MessageBox("ۑ̃t@Cw肳Ă܂B");
		return;
	}

	// t@CmF
	CFileStatus fileStatus;
	BOOL fileExists = CFile::GetStatus(m_BmpFile, fileStatus);
	if (fileExists) {
		CString msg = m_BmpFile + CString("͊łB㏑܂H");
		int mbRes = MessageBox(msg, "mF", MB_YESNO);
		if (mbRes != IDYES) {
			// LZ
			return;
		}
	}

	CRes res = ExecSaveBmpFul(m_BmpFile, m_scriptBasePath);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// CSVɃIy[Vǉ
	CsvEntry entry(CSVCMD_SAVE_BMP_FUL);
	entry.AddParam(m_BmpFile, true);
	m_operationCsv.Add(entry);

	// ʍĕ`
	MakeAllImages();
	DrawScreenAll();

	// IbZ[W
	MessageBox("BMPt@Cۑ܂B");
}

/// <summary>
/// CSVۑpX̎Qƃ{^
/// </summary>
void CSpconvDlg::OnBnClickedButtonScriptFilenameRef()
{
	UpdateData();

	CFileDialog dlg(
		FALSE, "csv", m_scriptFilename, OFN_HIDEREADONLY | OFN_NONETWORKBUTTON | OFN_PATHMUSTEXIST, "CSVt@C|*.csv||"
	);

	if (dlg.DoModal() == IDOK) {						// _CAO\
		m_scriptFilename = dlg.GetPathName();			// t@Cl[擾
		UpdateData(false);
	}
}

/// <summary>
/// CSVۑ
/// </summary>
void CSpconvDlg::OnBnClickedButtonSaveCsv()
{
	UpdateData();
	
	// t@CmF
	if (m_scriptFilename.GetLength() == 0) {
		MessageBox("CSVt@Cw肳Ă܂B");
		return;
	}

	CFileStatus fileStatus;
	BOOL fileExists = CFile::GetStatus(m_scriptFilename, fileStatus);
	if (fileExists) {
		CString msg = m_scriptFilename + CString("͊łB㏑܂H");
		int mbRes = MessageBox(msg, "mF", MB_YESNO);
		if (mbRes != IDYES) {
			// LZ
			return;
		}
	}

	// t@CJ
	FILE* fn = fopen(m_scriptFilename, "wt");
	if (fn == NULL) {
		MessageBox("CSVt@CJ܂łB");
		return;
	}

	// 1sڂ
	CString str = m_csvList;
	str.Replace("\r\n", "\n");
	fprintf(fn, "%s,%s\n", CSVCMD_SET_BASEPATH, (LPCTSTR)m_scriptBasePath);
	fprintf(fn, "%s", (LPCTSTR)str);

	// t@C
	fclose(fn);

	MessageBox("CSVXNvgۑ܂B");
}

/// <summary>
/// CSVꊇǂݍ
/// </summary>
void CSpconvDlg::OnBnClickedButtonReadCsv()
{
	CRes result;

	OnClear();
	UpdateData();

	// OmF
	if (m_scriptFilename.GetLength() <= 0) {
		MessageBox("CSVt@C͂Ă܂B");
		return;
	}

	// ㏑mF
	CFileStatus fileStatus;
	BOOL fileExists = CFile::GetStatus(m_scriptFilename, fileStatus);
	if (!fileExists) {
		CString msg = m_scriptFilename + CString("܂łB");
		MessageBox(msg);
		return;
	}

	// t@C荞
	m_operationCsv.RemoveAll();
	result = CsvEntry::FromFile(m_scriptFilename, m_operationCsv);
	if (!result.GetResult()) {
		CString msg;
		msg.Format("CSVt@C̓ǂݍ݁E߂Ɏs܂B\r\n%s", (LPCTSTR)(result.GetMsg()));
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// x[XpXw肪ꍇ́A荞
	CString basePath = CsvEntry::AdjustAboutBasePath(m_operationCsv);
	if (!basePath.IsEmpty()) {
		m_scriptBasePath = basePath;
	}

	// CSVeLXgč\z
	m_csvList = CsvEntry::BuildCsvText(m_operationCsv);

	// R}hXgs
	result = ExecOperationCsv(m_operationCsv, m_scriptBasePath);
	if (result.GetResult() == FALSE) {
		MessageBox(result.GetMsg(), MB_OK);
	}

	// ʍXV
	MakeAllImages();
	DrawScreenAll();

	UpdateData(false);
}

/// <summary>
/// CSVs
/// </summary>
/// <param name="operationCsv"></param>
CRes CSpconvDlg::ExecOperationCsv(CArray<CsvEntry>& operationCsv, CString basePath)
{
	// 1s
	int line = 0;
	for (int i = 0; i < operationCsv.GetSize(); i++) {
		CsvEntry csvEntry = operationCsv.GetAt(i);
		line += 1;

		// R}hƂɏ
		CRes result = ExecOperationEntry(csvEntry, basePath);
		if (!result.GetResult()) {
			// G[
			CString errorMessage;
			errorMessage.Format("%s\r\nline : %d", (LPCTSTR)(result.GetMsg()), line);
			return CRes::CreateError((LPCTSTR)errorMessage);
		}
	}

	// I
	MakeAllImages();
	DrawScreenAll();

	return CRes::CreateOk();
}

/// <summary>
/// CsvEntrys
/// </summary>
/// <param name="entry"></param>
/// <returns></returns>
CRes CSpconvDlg::ExecOperationEntry(CsvEntry& entry, CString basePath)
{
	// R}h荞
	CString command = CString(entry.command);

	// R}hɂČĂѕ
	CRes result = CRes::CreateOk();
	if (command.Compare(CSVCMD_NOP) == 0) {
		result = CRes::CreateOk();
	}
	if (command.Compare(CSVCMD_COMMENT) == 0) {
		// Rg͉Ȃ
		result = CRes::CreateOk();
	}
	else if (command.Compare(CSVCMD_ERROR) == 0) {
		result = CRes::CreateError("sȃG[");
	}
	else if (command.Compare(CSVCMD_READ_PALET) == 0) {
		CString palFile = entry.GetParamStr(0);
		int palReadTo = entry.GetParamInt(1);
		int palReadOffset = entry.GetParamInt(2);
		int palReadCount = entry.GetParamInt(3);

		result = ExecReadPalet(palFile, palReadTo, palReadOffset, palReadCount, basePath);
	}
	else if (command.Compare(CSVCMD_READ_SP) == 0) {
		CString spFile = entry.GetParamStr(0);
		int spReadTo = entry.GetParamHex(1);
		int spReadOffset = entry.GetParamInt(2);
		int spReadCount = entry.GetParamInt(3);
		int spAssumedPal = entry.GetParamInt(4);

		result = ExecReadSp(spFile, spReadTo, spReadOffset, spReadCount, spAssumedPal, basePath);
	}
	else if (command.Compare(CSVCMD_READ_BMP_PAL) == 0) {
		CString bmpBmpFilename = entry.GetParamStr(0);
		int bmpPalReadTo = entry.GetParamInt(1);
		int bmpPalReadOffset = entry.GetParamInt(2);
		int bmpPalReadCount = entry.GetParamInt(3);

		result = ExecReadBmpPal(bmpBmpFilename, bmpPalReadTo, bmpPalReadOffset, bmpPalReadCount, basePath);
	}
	else if (command.Compare(CSVCMD_READ_BMP_SP) == 0) {
		CString bmpBmpFilename = entry.GetParamStr(0);
		int bmpSpSizeX = entry.GetParamInt(1);
		int bmpSpSizeY = entry.GetParamInt(2);
		int bmpSpFrameCount = entry.GetParamInt(3);
		int bmpSpReadTo = entry.GetParamHex(4);
		int bmpSpReadOffset = entry.GetParamInt(5);
		int bmpPalReadTo = entry.GetParamInt(6);
		int bmpPalReadOffset = entry.GetParamInt(7);
		int bmpPalReadCount = entry.GetParamInt(8);
		BOOL bmpPalShift = entry.GetParamBool(9);

		result = ExecReadBmpSp( bmpBmpFilename, bmpSpSizeX, bmpSpSizeY
			, bmpSpFrameCount, bmpSpReadTo, bmpSpReadOffset
			, bmpPalReadTo, bmpPalReadOffset, bmpPalReadCount
			, bmpPalShift, basePath
		);
	}
	else if (command.Compare(CSVCMD_SAVE_SP_PAL) == 0) {
		CString spSaveSpFilename = entry.GetParamStr(0);
		int spSaveSpFrom = entry.GetParamHex(1);
		int spSaveSpCount = entry.GetParamInt(2);
		CString spSavePalFilename = entry.GetParamStr(3);
		int spSavePalFrom = entry.GetParamInt(4);
		int spSavePalCount = entry.GetParamInt(5);

		result = ExecSaveSpPal(spSaveSpFilename, spSaveSpFrom, spSaveSpCount
			, spSavePalFilename, spSavePalFrom, spSavePalCount, basePath);
	}
	else if (command.Compare(CSVCMD_SAVE_BMP_CNV) == 0) {
		CString bmpFile = entry.GetParamStr(0);
		CString dirName = entry.GetParamStr(1);
		CString mainName = entry.GetParamStr(2);
		BOOL bmpSaveAutoSw = entry.GetParamBool(3);
		int selectedPalBlock = entry.GetParamInt(4);

		result = ExecSaveBmpCnv(bmpFile, dirName, mainName, bmpSaveAutoSw, basePath, FALSE, selectedPalBlock);
	}
	else if (command.Compare(CSVCMD_SAVE_BMP_CNV256) == 0) {
		CString bmpFile = entry.GetParamStr(0);
		CString dirName = entry.GetParamStr(1);
		CString mainName = entry.GetParamStr(2);
		BOOL bmpSaveAutoSw = entry.GetParamBool(3);

		result = ExecSaveBmpCnv(bmpFile, dirName, mainName, bmpSaveAutoSw, basePath, TRUE, SelectedPalBlock);
	}
	else if (command.Compare(CSVCMD_SAVE_BMP_FUL) == 0) {
		CString bmpFile = entry.GetParamStr(0);

		result = ExecSaveBmpFul(bmpFile, basePath);
	}
	else if (command.Compare(CSVCMD_SET_BASEPATH) == 0) {
		CString basePath = entry.GetParamStr(0);
		m_scriptBasePath = basePath;
		result = CRes::CreateOk();
	}

	// ʂԂ
	return result;
}

// ReadPalets
CRes CSpconvDlg::ExecReadPalet(CString palFile, int palReadTo, int palReadOfset, int palReadCount, CString basePath)
{
	CString filepath = JoinBasePath(palFile, basePath);

	// ǂݍݐƌ̊m
	WORD* pReadTo = (WORD*)(pal_data[palReadTo]);

	// PALǂݍ
	FILE* stream = fopen((LPCTSTR)filepath, "rb");			// o`kt@CI[v
	if (stream == 0) {										// I[vs̏ꍇ
		CString message;
		message.Format("[%s]͊J܂ł", (LPCTSTR)filepath);
		return CRes::CreateError(message);
	}

	// ItZbg̕ǂݎ̂
	char buffer[16 * 16 * 2];
	memset(buffer, 0, sizeof(buffer));
	int readCount = (int)fread(buffer, 16 * 2, palReadOfset, stream);

	// f[^ǂݍ
	readCount = (int)fread(pReadTo, 16 * 2, palReadCount, stream);
	fclose(stream);

	return CRes::CreateOk();
}

// ReadSp
CRes CSpconvDlg::ExecReadSp(CString spFile, int spReadToDec, int spReadOffset, int spReadCount, int spAssumedPal, CString basePath)
{
	CString filepath = JoinBasePath(spFile, basePath);

	// t@CI[v
	FILE* stream = fopen((LPCTSTR)filepath, "rb");							// rot@CI[v
	if (stream == 0) {											// I[vs̏ꍇ
		CString message;
		message.Format("[% s]J܂ł", (LPCTSTR)filepath);
		return CRes::CreateError(message);
	}

	// ǂݍ
	int indexX = spReadToDec & 15;
	int indexY = spReadToDec / 16;
	char* pReadTo = sp_data[indexY][indexX];
	int sprCount = 0;
	// OffsetXLbv
	for (int i = 0; i < spReadOffset; i++) {
		// ǂݎ̂
		int result = (int)fread(pReadTo, (16 * 16) / 2, 1, stream);
	}
	// ǂݍ
	for (int i = 0; i < spReadCount; i++) {
		// ǂݍݐ̍őCfbNX̃NbsO
		if ((spReadToDec + i) > 255) { break; }
		// ǂݍ
		int result = (int)fread(pReadTo, (16 * 16) / 2, 1, stream);
		if (result == 0) { break; }	// EOF
		pReadTo += (16 * 16) / 2;
		sprCount += 1;
	}

	// t@C
	fclose(stream);

	// 摜
	MakeSpImage();			// roC[W
	for (int i = 0; i < sprCount; i++) {
		if ((spReadToDec + i) >= 256) { break; }
		SpToBmp(spReadToDec + i, spAssumedPal);
	}

	// ]
	TranslateSpToBmp(spReadToDec, spReadToDec + spReadCount - 1, spAssumedPal);

	return CRes::CreateOk();
}

// ReadBmpPal
CRes CSpconvDlg::ExecReadBmpPal(CString bmpBmpFilename, int bmpPalReadTo, int bmpPalReadOffset, int bmpPalReadCount, CString basePath)
{
	// 
	// t@CJ
	//
	CString filename = JoinBasePath(bmpBmpFilename, basePath);
	CFileStatus bmpFileStatus;
	BOOL fileExists = CFile::GetStatus(filename, bmpFileStatus);
	if (!fileExists) {
		CString msg = CString("w肳ꂽt@CJ܂łB") + CString(filename) + CString("]");
		return CRes::CreateError(msg);
	}

	// bmpǂݍ
	CDC* pDC = GetDC();
	Cfbmp bmp(filename, pDC);
	if ((bmp.GetColorDepth() != 4) && (bmp.GetColorDepth() != 8)) {
		CString msg = CString("16F256FBMPw肵ĂB");
		return CRes::CreateError(msg);
	}

	// BitOperationJn
	tximage->PrepareBitOperation();

	// 摜pbg荞
	{
		int pal_block_count = (1 << bmp.GetColorDepth()) / 16;
		WORD bmp_pal_data[16][16];
		memset(bmp_pal_data, 0, sizeof(bmp_pal_data));
		for (int i = 0; i < pal_block_count * 16; i++) {
			RGBQUAD quad = bmp.GetPalet(i);
			int r = (int)((32.0 * (double)(quad.rgbRed)) / 256.0);
			int g = (int)((32.0 * (double)(quad.rgbGreen)) / 256.0);
			int b = (int)((32.0 * (double)(quad.rgbBlue)) / 256.0);
			WORD pal = (g << 11) + (r << 6) + (b << 1) + 0;	// Pxrbg0
			pal = ((pal >> 8) & 255) + ((pal << 8) & 0xFF00);	// gGfBAɂ

			bmp_pal_data[i / 16][i & 15] = pal;
		}

		// pbg]
		int toBlock = bmpPalReadTo;
		int readBlockMax = (bmpPalReadOffset + bmpPalReadCount - 1);
		if (readBlockMax >= 16) { readBlockMax = 15; }
		for (int i = bmpPalReadOffset; i <= readBlockMax; i++) {
			for (int c = 0; c < 16; c++) {
				tximage->SetPalet((toBlock * 16) + c, bmp.GetPalet((i * 16) + c));
				pal_data[toBlock][c] = bmp_pal_data[i][c];
			}
			toBlock++;
			if (toBlock >= 16) { break; }
		}
	}

	// BitOperationI
	tximage->EndBitOperation(pDC);

	// \[X
	ReleaseDC(pDC);
	return CRes::CreateOk();
}

// ReadBmpSp
CRes CSpconvDlg::ExecReadBmpSp(
	CString bmpBmpFilename, int bmpSpSizeX, int bmpSpSizeY, int bmpSpFrameCount,
	int bmpSpReadTo, int bmpSpReadOffset, int bmpPalReadTo, int bmpPalReadOffset, int bmpPalReadCount,
	BOOL bmpPalShift, CString basePath)
{
	// 
	// t@CJ
	//
	CString filename = JoinBasePath(bmpBmpFilename, basePath);
	CFileStatus bmpFileStatus;
	BOOL fileExists = CFile::GetStatus(filename, bmpFileStatus);
	if (!fileExists) {
		CString msg = CString("w肳ꂽt@CJ܂łB") + CString(filename) + CString("]");
		return CRes::CreateError(msg);
	}

	// bmpǂݍ
	CDC* pDC = GetDC();
	Cfbmp bmp(filename, pDC);
	if ((bmp.GetColorDepth() != 4) && (bmp.GetColorDepth() != 8)) {
		return CRes::CreateError("16F256FBMPw肵ĂB");
	}

	// BitOperationJn
	tximage->PrepareBitOperation();

	// XvCg̏𐮗
	int sheetXCount = bmp.GetWidth() / (bmpSpSizeX * 16);
	int sheetYCount = bmp.GetHeight() / (bmpSpSizeY * 16);

	// 荞ݏ
	int processedFrames = 0;
	int maxFrameIndex = bmpSpReadOffset + bmpSpFrameCount - 1;
	for (int py = 0; py < bmp.GetHeight(); py += (bmpSpSizeY * 16)) {
		for (int px = 0; px < bmp.GetWidth(); px += (bmpSpSizeX * 16)) {
			// ItZbg
			if (processedFrames < bmpSpReadOffset) {
				// ItZbgt[܂ŏXLbv
				processedFrames++;
				continue;
			}

			// t[ׂďII
			if (processedFrames > maxFrameIndex) { break; }

			// p^[SPTCYWJ
			for (int cy = 0; cy < bmpSpSizeY; cy++) {
				for (int cx = 0; cx < bmpSpSizeX; cx++) {
					int sourceX = px + (cx * 16);
					int sourceY = py + (cy * 16);

					// BMP荞
					int idx = bmpSpReadTo	// ǂݍݐCfbNX
							+ ((processedFrames-bmpSpReadOffset) * (bmpSpSizeX * bmpSpSizeY))	// łɏSP̐
							+ (cy * bmpSpSizeX + cx);	// Ỹt[SP̃CfbNX
					int idxX = idx & 15;
					int idxY = idx / 16;

					// pbgԍVtgȂA̕␳
					int palOffset = 0;
					if (bmpPalShift) {
						palOffset = (bmpPalReadTo * 16) - (bmpPalReadOffset * 16);	// ǂݍݐƁAǂݍOffsetl
					}

					// SP
					for (int y = 0; y < 16; y++) {
						for (int x = 0; x < 16; x++) {
							int colCode = bmp.GetPixelIndex(sourceX + x, sourceY + y);
							int adjustedCode = colCode + palOffset;
							if ((adjustedCode < 0) || (adjustedCode >= 256) || (bmpPalShift == false)) {
								adjustedCode = colCode;
							}
							tximage->SetPixelIndex(idxX * 16 + x, idxY * 16 + y, adjustedCode);
						}
					}
				}
			}

			// 1t[
			processedFrames++;
		}
	}

	// BitOperationI
	tximage->EndBitOperation(pDC);

	// \[X
	ReleaseDC(pDC);

	// BMPSPɃp^[]ʂ
	int transSpCount = (bmpSpSizeX * bmpSpSizeY) * (sheetXCount * sheetYCount);
	int toIndex = bmpSpReadTo + transSpCount - 1;
	if (toIndex >= 256) { toIndex = 255; }
	TranslateBmpToSp(bmpSpReadTo, toIndex);

	return CRes::CreateOk();
}

// SaveSpPal
CRes CSpconvDlg::ExecSaveSpPal(CString spSaveSpFilename, int spSaveSpFromDec, int spSaveSpCount
	, CString spSavePalFilename, int spSavePalFrom, int spSavePalCount, CString basePath)
{
	// t@CwLmF
	if (spSaveSpFilename.GetLength() == 0) {
		return CRes::CreateError("SPt@C̏o͐悪w肳Ă܂B");
	}
	if (spSavePalFilename.GetLength() == 0) {
		return CRes::CreateError("PALt@C̏o͐悪w肳Ă܂B");
	}

	CString spFilepath = JoinBasePath(spSaveSpFilename, basePath);
	CString palFilepath = JoinBasePath(spSavePalFilename, basePath);

	char* pSpTop = ((char*)sp_data) + (spSaveSpFromDec * 128);
	int spSSC = spSaveSpCount;
	if ((spSaveSpFromDec + spSaveSpCount) > 256) {
		spSSC = 256 - spSaveSpFromDec;
	}

	// SPt@Cۑ
	FILE* fn;
	fn = fopen((LPCTSTR)spFilepath, "wb");
	if (fn == NULL) {
		CString message;
		message.Format("SPt@CJ܂łBFilePath = %s\n", spFilepath);
		return CRes::CreateError(message);
	}
	fwrite((void*)pSpTop, (16 * 16 / 2), spSSC, fn);
	fclose(fn);

	// PAL̐擪AhXƌm肳
	char* pPalTop = ((char*)pal_data) + (spSavePalFrom * 16 * 2);
	int spSPC = spSavePalCount;
	if ((spSavePalFrom + spSavePalCount) > 16) {
		spSPC = 16 - spSavePalFrom;
	}

	// PALt@Cۑ
	fn = fopen((LPCTSTR)palFilepath, "wb");
	if (fn == NULL) {
		CString message;
		message.Format("PALt@CJ܂łBFilePath = %s\n", palFilepath);
		return CRes::CreateError(message);
	}
	fwrite((void*)pPalTop, 2 * 16, spSPC, fn);
	fclose(fn);

	return CRes::CreateOk();
}

// SaveBmpCnv
CRes CSpconvDlg::ExecSaveBmpCnv(CString bmpFile, CString dirName, CString mainName, BOOL bmpSaveAutoSw, CString basePath, BOOL indexedColor, int selectedPalBlock)
{
	// pbgubNđI
	SelectedPalBlock = selectedPalBlock;		// pbgubNݒ
	//MakeSpImage();								// roC[W
	MakeAllImages();
	DrawScreenAll();

	dirName = JoinBasePath(dirName, basePath);

	if (bmpSaveAutoSw) {				//--------- I[g̏ꍇ
		if (dirName == "") {
			return CRes::CreateError("o͂̓WJfBNgw肳Ă܂");
		}
		if (mainName == "") {
			return CRes::CreateError("o͂alot@C̎t@Cw肳Ă܂");
		}
	}
	else {							//------------ I[gȂꍇ
		if (bmpFile == "") {
			return CRes::CreateError("o͂BMPt@Cw肳Ă܂");
		}
	}

	if (bmpSaveAutoSw) {				//--------- I[g̏ꍇ
		int i;
		int oldPal = SelectedPalBlock;
		for (i = 0; i < 16; i++) {
			char tempstring[3];					// ԍ
			tempstring[0] = '0' + (i + 1) / 10;
			tempstring[1] = '0' + (i + 1) % 10;
			tempstring[2] = 0;
			CString temp, full;
			temp = mainName + tempstring + ".bmp";		// t@C
			full = MakeFullPathName(dirName, temp);		// tpXl[

			SelectedPalBlock = i;						// pbgubNݒ
			//MakeSpImage();								// roC[W
			MakeAllImages();
			DrawScreenAll();							// Ŝ`
			SaveBmp(full, indexedColor);								// aloZ[u
		}
		SelectedPalBlock = oldPal;						// pbgɖ߂
		//MakeSpImage();									// C[Wč\z
		MakeAllImages();
		DrawScreenAll();								// `Ă
	}
	else {							//------------ I[gȂꍇ
		CString filepath = JoinBasePath(bmpFile, basePath);
		SaveBmp(filepath, indexedColor);								// alo
	}

	return CRes::CreateOk();
}

// SaveBmpFul
CRes CSpconvDlg::ExecSaveBmpFul(CString bmpFile, CString basePath)
{
	if (bmpFile.GetLength() <= 0) {
		return CRes::CreateError("ۑ̃t@Cw肳Ă܂B");
	}

	// ۑ
	MakeAllImages();
	DrawScreenAll();
	CString filepath = JoinBasePath(bmpFile, basePath);
	CString filepathMain = filepath.Left(filepath.GetLength() - 4);
	CString filepath_a = filepathMain + "_a.bmp";

	BOOL result = doSave(filepath, tximage);
	if (!result) {
		CRes res = CRes::CreateError("BMPt@C̕ۑɎs܂B");
		return res;
	}

	result = doSaveStencil(filepath_a, tximage);
	if (!result) {
		CRes res = CRes::CreateError("StencilBMPt@C̕ۑɎs܂B");
		return res;
	}

	return CRes::CreateOk();
}

// JoinBasePath
CString CSpconvDlg::JoinBasePath(CString filename, CString basePath)
{
	// filenameȂ炻̂܂
	if (filename.GetLength() == 0) {
		return filename;
	}

	// basePath̎w肪Ȃfilenamê܂
	if (basePath.IsEmpty()) {
		return filename;
	}

	// filenametpXȂ炻̂܂
	if (filename.GetAt(1) == ':') {
		return filename;
	}
	if (filename.GetAt(0) == '\\') {
		return filename;
	}

	// basepath̖ \ 
	basePath = basePath + "\\";
	basePath.Replace("\\\\", "\\");

	// filenameƌ
	CString result = basePath + filename;

	// ʂԂ
	return result;
}

void CSpconvDlg::OnBnClickedButtonExecCsv()
{
	UpdateData();

	// NAĂs
	OnClear();

	// eLXg烊Xg\z
	CArray<CsvEntry> operationCsv;
	CRes res = CsvEntry::FromCsvText(m_csvList, operationCsv);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// \zɐs
	CsvEntry::FromCsvText(m_csvList, m_operationCsv);

	// s
	res = ExecOperationCsv(m_operationCsv, m_scriptBasePath);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// sI
	MakeAllImages();
	DrawScreenAll();
	UpdateData(false);
}


void CSpconvDlg::OnEnKillfocusEditCsvlist()
{
	UpdateData();

	// eLXg烊Xg\z
	CArray<CsvEntry> operationCsv;
	CRes res = CsvEntry::FromCsvText(m_csvList, operationCsv);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// \zɐs
	CsvEntry::FromCsvText(m_csvList, m_operationCsv);

	// ĕ`
	MakeAllImages();
	DrawScreenAll();
}


void CSpconvDlg::OnBnClickedButtonSave256()
{
	UpdateData(TRUE);									// f[^oϐ֎荞

	// t@CmF
	if (!m_bmpSaveAutoSw) {
		CFileStatus fileStatus;
		BOOL fileExists = CFile::GetStatus(m_BmpFile, fileStatus);
		if (fileExists) {
			CString msg = m_BmpFile + CString("͊łB㏑܂H");
			int mbRes = MessageBox(msg, "mF", MB_YESNO);
			if (mbRes != IDYES) {
				// LZ
				return;
			}
		}
	}

	if (m_bmpSaveAutoSw) {				//--------- I[g̏ꍇ
		if (m_DirName == "") {
			MessageBox("o͂̓WJfBNgw肳Ă܂");
			return;
		}
		if (m_MainName == "") {
			MessageBox("o͂alot@C̎t@Cw肳Ă܂");
			return;
		}
	}
	else {							//------------ I[gȂꍇ
		if (m_BmpFile == "") {
			MessageBox("o͂BMPt@Cw肳Ă܂");
			return;
		}
	}

	CRes res = ExecSaveBmpCnv(m_BmpFile, m_DirName, m_MainName, m_bmpSaveAutoSw, m_scriptBasePath, TRUE, SelectedPalBlock);
	if (!res.GetResult()) {
		MessageBox(res.GetMsg());
		MakeAllImages();
		DrawScreenAll();
		return;
	}

	// CSVɃIy[Vǉ
	CsvEntry entry(CSVCMD_SAVE_BMP_CNV256);
	entry.AddParam(m_BmpFile, true);
	entry.AddParam(m_DirName, true);
	entry.AddParam(m_MainName, true);
	entry.AddParamBool(m_bmpSaveAutoSw);
	m_operationCsv.Add(entry);

	// ʍĕ`
	MakeAllImages();
	DrawScreenAll();

	// IbZ[W
	MessageBox("BMPt@Cۑ܂B");
}
