//
// CSVEntry
//
#include "stdafx.h"
#include "stdio.h"
#include "stdlib.h"

#include "CsvEntry.h"
#include "CRes.h"

/// <summary>
/// RXgN^
/// </summary>
CsvEntry::CsvEntry()
{
	command = "";
	params.RemoveAll();
	paramsOrig.RemoveAll();
}

/// <summary>
/// RXgN^
/// </summary>
/// <param name="cmd"></param>
CsvEntry::CsvEntry(const char* cmd)
{
	command = cmd;
	params.RemoveAll();
	paramsOrig.RemoveAll();
}

/// <summary>
/// Rs[RXgN^
/// </summary>
/// <param name="entry"></param>
CsvEntry::CsvEntry(const CsvEntry& entry)
{
	command = entry.command;
	params.RemoveAll();
	paramsOrig.RemoveAll();

	for (int i = 0; i < entry.params.GetCount(); i++) {
		params.Add(entry.params[i]);
	}

	for (int i = 0; i < entry.paramsOrig.GetCount(); i++) {
		paramsOrig.Add(entry.paramsOrig[i]);
	}
}

/// <summary>
/// Zq
/// </summary>
/// <param name="entry"></param>
/// <returns></returns>
CsvEntry& CsvEntry::operator=(const CsvEntry& entry)
{
	command = entry.command;
	params.RemoveAll();
	paramsOrig.RemoveAll();

	for (int i = 0; i < entry.params.GetCount(); i++) {
		params.Add(entry.params[i]);
	}

	for (int i = 0; i < entry.paramsOrig.GetCount(); i++) {
		paramsOrig.Add(entry.paramsOrig[i]);
	}

	return *this;
}

/// <summary>
/// fXgN^
/// </summary>
CsvEntry::~CsvEntry()
{
	command = "";
	params.RemoveAll();
	paramsOrig.RemoveAll();
}

/// <summary>
/// CSV̕Ԃ
/// </summary>
/// <returns></returns>
CString CsvEntry::GetCsvLine()
{
	CString line;

	// Rg̏ꍇ͓ȏ
	if (command.Compare(CSVCMD_COMMENT) == 0) {
		line = CString("#");
		if (params.GetSize() > 0) {
			line += GetParamStr(0);
		}
		return line;
	}

	// CSV
	line = command;
	for (int i = 0; i < params.GetSize(); i++) {
		line += ",";
		line += params[i];
		if (params[i].GetLength() == 0) {
			// 󕶎̏ꍇ͓̕ŕ⊮
			line += RESERVED_EMPTY;
		}
	}
	return line;
}

/// <summary>
/// p[^ǉ
/// </summary>
/// <param name="param"></param>
void CsvEntry::AddParam(CString param, bool trim)
{
	// 󕶎Ȃ\Œu
	if (trim) {
		if (param.Trim().GetLength() == 0) {
			param = RESERVED_EMPTY;
		}
	}
	else {
		if (param.GetLength() == 0) {
			param = RESERVED_EMPTY;
		}
	}

	// vfǉ
	params.Add(param);
	paramsOrig.Add(param);
}

/// <summary>
/// p[^ǉ
/// </summary>
/// <param name="param"></param>
void CsvEntry::AddParam(const char* param, bool trim)
{
	this->AddParam(CString(param), trim);
}

void CsvEntry::AddParam(int param)
{
	CString val, valOrig;
	val.Format("%d", param);
	valOrig.Format("%d", param);
	params.Add(val);
	paramsOrig.Add(valOrig);
}

void CsvEntry::AddParamBool(BOOL param)
{
	CString val, valOrig;
	if (param) {
		val = CString("true");
		valOrig = CString("true");
	}
	else {
		val = CString("false");
		valOrig = CString("false");
	}
	params.Add(val);
	paramsOrig.Add(valOrig);
}

/// <summary>
/// x[XpXOtpX\𑊑΃pXɕύX
/// </summary>
/// <param name="basePath"></param>
void CsvEntry::AdjustBasePath(const char* basePath)
{
	// R}hɂĂ͉Ȃ
	if (false) {
		return;
	}

	// p[^Ƃɏ
	params.RemoveAll();
	for (int i = 0; i < paramsOrig.GetSize(); i++) {
		CString val = paramsOrig[i];
		val = AdjustBasePathCore(basePath, (LPCTSTR)val);
		params.Add(val);
	}
}

/// <summary>
/// pX𒲐
/// </summary>
/// <param name="value"></param>
/// <returns></returns>
CString CsvEntry::AdjustBasePathCore(const char* basePath, const char* value)
{
	CString val = value;
	CString base = basePath;

	// x[XpXw肪Ȃ΂̂܂܏I
	if (base.GetLength() <= 0) {
		return val;
	}

	if (base.GetAt(base.GetLength() - 1) != '\\') {
		base.Append("\\");
	}
	
	int pos = val.Find(base);
	if (pos == 0) {
		// x[XpXŊJnĂꍇ̓pXO
		val = ((LPCTSTR)val) + base.GetLength();
		while ((val.GetAt(0) == '\\') || (val.GetAt(0) == '/')) {
			val = ((LPCTSTR)val) + 1;
		}
	}

	return val;
}

int CsvEntry::GetParamInt(int index)
{
	CString str = params.GetAt(index);
	int val = 0;
	int count = sscanf((LPCTSTR)str, "%d", &val);
	if (count <= 0) {
		return 0;
	}
	return val;
}

int CsvEntry::GetParamHex(int index)
{
	CString str = params.GetAt(index);
	int val = 0;
	int count = sscanf((LPCTSTR)str, "%02X", &val);
	if (count <= 0) {
		return 0;
	}
	return val;
}

CString CsvEntry::GetParamStr(int index)
{
	return params.GetAt(index);
}

BOOL CsvEntry::GetParamBool(int index)
{
	CString str = params.GetAt(index);
	CString upper = str.MakeUpper();
	if (upper.Compare("TRUE")==0) {
		return TRUE;
	}
	return FALSE;
}


/// <summary>
/// 񂩂CsvEntity\z
/// </summary>
/// <param name="line"></param>
/// <returns></returns>
CsvEntry CsvEntry::FromString(CString line)
{
	// 1ڂ̃g[N𓾂
	int nTokenPos = 0;
	CString strToken = line.Tokenize(_T(","), nTokenPos).Trim();
	if (strToken.GetAt(0) == '#') {
		// Rg
		int strLength = strToken.GetLength();
		CString comment = strToken.Right(strLength-1);

		CsvEntry result;
		result.command = CSVCMD_COMMENT;
		if (comment.GetLength() > 0) {
			result.AddParam(comment, false);
		}
		return result;
	}
	CString command = CString((LPCTSTR)strToken);

	// p[^荞
	CStringArray params;
	strToken = line.Tokenize(_T(","), nTokenPos).Trim();
	while (!strToken.IsEmpty()) {
		// g[N\̋󕶎Ȃϊ
		if (strToken == RESERVED_EMPTY) {
			strToken = "";
		}

		// vfǉ
		params.Add(strToken);
		strToken = line.Tokenize(_T(","), nTokenPos);
	}

	// CsvEntity\z
	CsvEntry entity;
	entity.command = command;
	for (int i = 0; i < params.GetCount(); i++) {
		entity.params.Add(params[i]);
		entity.paramsOrig.Add(params[i]);
	}

	// ʂԂ
	return entity;
}

/// <summary>
/// t@CCSV荞targetɓ
/// </summary>
/// <param name="filename"></param>
/// <param name="target"></param>
/// <returns></returns>
CRes CsvEntry::FromFile(CString filename, CArray<CsvEntry>& target)
{
	// ܂
	target.RemoveAll();

	// t@CJ
	FILE* fn = fopen(filename, "rt");

	// 1sǂŏ
	char buffer[256];
	while (fgets(buffer, 255, fn) != NULL) {
		CString line(buffer);
		line.Trim();
		if (line.GetLength() == 0) {
			// s
			continue;
		}

		// CsvEntryɕϊ
		CsvEntry entry = CsvEntry::FromString(line);
		if (strcmp((LPCTSTR)entry.command, CSVCMD_NOP)==0) {
			// NOPȂ疳
			continue;
		}
		if (strcmp((LPCTSTR)entry.command, CSVCMD_ERROR) == 0) {
			// ERRORȂ璆f
			CString msg;
			msg.Format("CSṼp[XɎs܂B[%s]", (LPCTSTR)line);
			CRes result = CRes::CreateError((LPCTSTR)line);
			fclose(fn);
			return result;
		}

		// Xgɒǉ
		target.Add(entry);
	}
	return CRes::CreateOk();
}

/// <summary>
/// CSṼeLXg荞targetɓ
/// </summary>
/// <param name="csvText"></param>
/// <param name="target"></param>
/// <returns></returns>
CRes CsvEntry::FromCsvText(CString csvText, CArray<CsvEntry>& target)
{
	// ܂
	target.RemoveAll();
	CString source = csvText;
	source.Trim();
	source.Replace("\r\n", "\n");

	// 1sǂŏ
	int nTokenPos = 0;
	CString line = source.Tokenize(_T("\n"), nTokenPos).Trim();
	while (!line.IsEmpty()) {

		line.Trim();

		// CsvEntryɕϊ
		CsvEntry entry = CsvEntry::FromString(line);
		if (strcmp((LPCTSTR)entry.command, CSVCMD_NOP) == 0) {
			// NOPȂ疳
			line = source.Tokenize(_T("\n"), nTokenPos).Trim();
			continue;
		}
		if (strcmp((LPCTSTR)entry.command, CSVCMD_ERROR) == 0) {
			// ERRORȂ璆f
			CString msg;
			msg.Format("CSṼp[XɎs܂B[%s]", (LPCTSTR)line);
			CRes result = CRes::CreateError((LPCTSTR)line);
			return result;
		}

		// Xgɒǉ
		target.Add(entry);

		// ̍s
		line = source.Tokenize(_T("\n"), nTokenPos);
	}
	return CRes::CreateOk();
}

/// <summary>
/// CArray<CsvEntry> AeLXgGApCSṼeLXg\zĕԂ
/// </summary>
/// <param name="target"></param>
/// <returns></returns>
CString CsvEntry::BuildCsvText(CArray<CsvEntry>& target)
{
	CString result = "";
	for (int i = 0; i < target.GetSize(); i++) {
		CsvEntry entry = target.GetAt(i);
		if (result.GetLength() != 0) {
			result += "\r\n";
		}
		result += entry.GetCsvLine();
	}

	// ʂԂ
	return result;
}

/// <summary>
/// CArray<CsvEntry> Ax[XpXw̍ڂăx[XpXԂ
/// </summary>
/// <param name="target"></param>
/// <returns></returns>
CString CsvEntry::AdjustAboutBasePath(CArray<CsvEntry>& target)
{
	CString basePath = "";

	int listSize = (int)( target.GetSize() );
	for (int i = listSize - 1; i >= 0 ; i--) {
		CsvEntry entry = target.GetAt(i);
		if (strcmp((LPCTSTR)(entry.command), CSVCMD_SET_BASEPATH) == 0) {
			basePath = entry.params.GetAt(i);
			target.RemoveAt(i);
		}
	}

	// ʂԂ
	return basePath;
}
