//
//  GTNLIB for VC++
//
#include "pch.h"
#include "framework.h"

#include "cfbmp.h"


//-------------------------------------------------------<<  >>
Cfbmp::Cfbmp()										// ftHgRXgN^
{
	isSet=FALSE;						// f[^̓ZbgĂȂB
	isBitOperating=FALSE;				// rbgz̑쒆ł͂Ȃ
}

Cfbmp::Cfbmp(LPCTSTR fname,CDC* pDC)				// t@CwRXgN^
{
	isSet=FALSE;						// Ƃ肠...
	isBitOperating=FALSE;				// rbgz̑쒆ł͂Ȃ
	Load(fname,pDC);					// ɂ܂
}

Cfbmp::Cfbmp( int SizeX , int SizeY , int BitDepth , CDC* pDC )	// TCYArbg[xwRXgN^
{
	isSet=FALSE;						// Ƃ肠...
	isBitOperating=FALSE;				// rbgz̑쒆ł͂Ȃ

//							<< rbgz̃TCYvZ >>
	UINT uSizeImage;
	uSizeImage = (SizeX*BitDepth)/8;								// oCg
	uSizeImage += ( 4-(uSizeImage&3) )&3;							// SoCgE
	uSizeImage *= SizeY;											// đŜ̃TCY

//							<< Bitmap File Header 쐬 >>
	UINT nColors = 1<<BitDepth;
	UINT QuadSize;
	if( BitDepth>=24 )QuadSize=0;
	else QuadSize=sizeof(RGBQUAD)*nColors;

	bmfh.bfType = 0x4d42;
	bmfh.bfSize = sizeof( BITMAPINFOHEADER )+sizeof( BITMAPFILEHEADER )
		+QuadSize+uSizeImage;
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = sizeof( BITMAPINFOHEADER )+sizeof( BITMAPFILEHEADER )
		+QuadSize;

//							<< Bitmap Info Header 쐬 >>
	bmih.biSize = sizeof( BITMAPINFOHEADER );
	bmih.biWidth = SizeX;
	bmih.biHeight = SizeY;
	bmih.biPlanes = 1;
	bmih.biBitCount = BitDepth;
	bmih.biCompression = 0;
	bmih.biSizeImage = uSizeImage;
	bmih.biXPelsPerMeter = 0;
	bmih.biYPelsPerMeter = 0;
	bmih.biClrUsed = 0;
	bmih.biClrImportant = 0;

//							<< tJ[ǂ >>
	if( BitDepth>=24 )isFullColor = TRUE;
	else isFullColor = FALSE;


//							<< BITMAPINFO 쐬 >>
	if(bmih.biClrUsed!=0)nColors=bmih.biClrUsed;
	else nColors=1 << bmih.biBitCount;

	if(bmih.biBitCount<24)
	{	// tJ[łȂꍇ
		lpbmi=(LPBITMAPINFO)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*nColors);
		lpbmi->bmiHeader=bmih;
	}
	else
	{	// tJ[̏ꍇ
		lpbmi=(LPBITMAPINFO)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD));
		lpbmi->bmiHeader=bmih;
	}

//							<< nh̍쐬 >>
																	// BMP쐬
	lpBits=(void*)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,uSizeImage);	// DIBobt@m
	memset( lpBits , 0 , uSizeImage );								// Oŉ摜

	hBmp=CreateDIBitmap(pDC->m_hDC,&bmih,CBM_INIT,lpBits,lpbmi,DIB_RGB_COLORS);	// nh쐬
	if(hBmp==NULL){										// sI
		GlobalFree(lpBits);			// DIBobt@
		GlobalFree((HGLOBAL)lpbmi);	// 
		return;
	}

//							<< pbgnh쐬 >>
	if(!isFullColor){						// tJ[Ȃꍇ̂݁B
		lpLogPal=(LPLOGPALETTE)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,sizeof(LOGPALETTE)+sizeof(PALETTEENTRY)*nColors);

		lpLogPal->palVersion=0x300;
		lpLogPal->palNumEntries=nColors;
		for(UINT i=0;i<nColors;i++){
			lpLogPal->palPalEntry[i].peRed=lpbmi->bmiColors[i].rgbRed;
			lpLogPal->palPalEntry[i].peGreen=lpbmi->bmiColors[i].rgbGreen;
			lpLogPal->palPalEntry[i].peBlue=lpbmi->bmiColors[i].rgbBlue;
		}

	hPal=CreatePalette(lpLogPal);			// pbgnh쐬
	}

	isSet=TRUE;					// Zbg
	return;				// I
}

Cfbmp::~Cfbmp()										// fXgN^
{
	Free();								// ̉
}


//---------------------------------------------------------<<  >>
//---------------------------------------------------<< t@CwŁAf[^[h >>
BOOL Cfbmp::Load(LPCTSTR fname,CDC* pDC)
{
	Free();								// f[^ǂݍ܂ĂꍇA܂j

//							<< wb_֘Ȁ >>
	BOOL bResult;						// u[lł̌ʊi[
	DWORD dwRead;
	HANDLE hFile;						// t@Cnh

	// t@CI[v
	hFile=CreateFile(fname,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile == NULL)return FALSE;				// t@CI[vs

	// rbg}bvt@Cwb_ǂݍ
	dwRead=0;
	bResult=ReadFile(hFile,&bmfh,sizeof(BITMAPFILEHEADER),&dwRead,NULL);
	if(bResult==FALSE||bmfh.bfType!=0x4D42){	// rbg}bvt@CȂHI
		CloseHandle(hFile);
		return FALSE;
	}

	// rbg}bvCtHwb_ǂݍ
	if(ReadFile(hFile,&bmih,sizeof(BITMAPINFOHEADER),&dwRead,NULL)==FALSE){
		CloseHandle(hFile);
		return FALSE;							// CtHwb_ǂ߂ȂHI
	}

//							<< pbg֘Ȁ >>
	UINT nColors;								// F

	if(bmih.biClrUsed!=0)nColors=bmih.biClrUsed;
	else nColors=1 << bmih.biBitCount;

	// pbgCfbNX̏ꍇ
	if(bmih.biBitCount<24)
	{
		isFullColor=FALSE;						// tJ[Ȃ
		lpbmi=(LPBITMAPINFO)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*nColors);
		lpbmi->bmiHeader=bmih;
		if(ReadFile(hFile,&(lpbmi->bmiColors),sizeof(RGBQUAD)*nColors,&dwRead,NULL)==FALSE){
			CloseHandle(hFile);
			GlobalFree((HGLOBAL)lpbmi);
			return FALSE;
		}
	}
	// tJ[̏ꍇ
	else
	{
		isFullColor=TRUE;						// tJ[
		lpbmi=(LPBITMAPINFO)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD));
		lpbmi->bmiHeader=bmih;
	}



//							<< nh̍쐬 >>
																	// BMP쐬
	UINT uSizeImage;												// TCYvZ
	uSizeImage = GetWidthByte()*bmih.biHeight;

	lpBits=(void*)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,uSizeImage);	// DIBobt@m

	if(ReadFile(hFile,lpBits,uSizeImage,&dwRead,NULL)==FALSE){	// f[^ǂݍ
		CloseHandle(hFile);			// t@Cnh
		GlobalFree(lpBits);			// DIBobt@
		GlobalFree((HGLOBAL)lpbmi);	// 
		return FALSE;
	}
	hBmp=CreateDIBitmap(pDC->m_hDC,&bmih,CBM_INIT,lpBits,lpbmi,DIB_RGB_COLORS);	// nh쐬
	if(hBmp==NULL){										// sI
		CloseHandle(hFile);			// t@Cnh
		GlobalFree(lpBits);			// DIBobt@
		GlobalFree((HGLOBAL)lpbmi);	// 
		return FALSE;
	}
	CloseHandle(hFile);									// t@CN[Y


//							<< pbgnh쐬 >>
	if(!isFullColor){						// tJ[Ȃꍇ̂݁B
		lpLogPal=(LPLOGPALETTE)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,sizeof(LOGPALETTE)+sizeof(PALETTEENTRY)*nColors);

		lpLogPal->palVersion=0x300;
		lpLogPal->palNumEntries=nColors;
		for(UINT i=0;i<nColors;i++){
			lpLogPal->palPalEntry[i].peRed=lpbmi->bmiColors[i].rgbRed;
			lpLogPal->palPalEntry[i].peGreen=lpbmi->bmiColors[i].rgbGreen;
			lpLogPal->palPalEntry[i].peBlue=lpbmi->bmiColors[i].rgbBlue;
		}

	hPal=CreatePalette(lpLogPal);			// pbgnh쐬
	}

	isSet=TRUE;					// Zbg
	return TRUE;				// I
}


//---------------------------------------------------<< TCYArbg[xw̃CjVCU >>
BOOL Cfbmp::Initialize( int SizeX , int SizeY , int BitDepth , CDC* pDC )
{
	Free();
	isSet=FALSE;						// Ƃ肠...

//							<< rbgz̃TCYvZ >>
	UINT uSizeImage;												// TCYvZ
	uSizeImage = (SizeX*BitDepth)/8;								// oCg
	uSizeImage += ( 4-(uSizeImage&3) )&3;							// SoCgE
	uSizeImage *= SizeY;											// đŜ̃TCY

//							<< Bitmap File Header 쐬 >>
	UINT nColors = 1<<BitDepth;
	UINT QuadSize;
	if( BitDepth>=24 )QuadSize=0;
	else QuadSize=sizeof(RGBQUAD)*nColors;

	bmfh.bfType = 0x4d42;
	bmfh.bfSize = sizeof( BITMAPINFOHEADER )+sizeof( BITMAPFILEHEADER )
		+QuadSize+uSizeImage;
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = sizeof( BITMAPINFOHEADER )+sizeof( BITMAPFILEHEADER )
		+QuadSize;

//							<< Bitmap Info Header 쐬 >>
	bmih.biSize = sizeof( BITMAPINFOHEADER );
	bmih.biWidth = SizeX;
	bmih.biHeight = SizeY;
	bmih.biPlanes = 1;
	bmih.biBitCount = BitDepth;
	bmih.biCompression = 0;
	bmih.biSizeImage = uSizeImage;
	bmih.biXPelsPerMeter = 0;
	bmih.biYPelsPerMeter = 0;
	bmih.biClrUsed = 0;
	bmih.biClrImportant = 0;

//							<< tJ[ǂ >>
	if( BitDepth>=24 )isFullColor = TRUE;
	else isFullColor = FALSE;


//							<< BITMAPINFO 쐬 >>
	if(bmih.biClrUsed!=0)nColors=bmih.biClrUsed;
	else nColors = 1<<bmih.biBitCount;

	if(bmih.biBitCount<24)
	{	// tJ[łȂꍇ
		lpbmi=(LPBITMAPINFO)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*nColors);
		lpbmi->bmiHeader=bmih;
	}
	else
	{	// tJ[̏ꍇ
		lpbmi=(LPBITMAPINFO)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD));
		lpbmi->bmiHeader=bmih;
	}

//							<< nh̍쐬 >>
																	// BMP쐬
	lpBits=(void*)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,uSizeImage);	// DIBobt@m
	memset( lpBits , 0 , uSizeImage );								// Oŉ摜

	hBmp=CreateDIBitmap(pDC->m_hDC,&bmih,CBM_INIT,lpBits,lpbmi,DIB_RGB_COLORS);	// nh쐬
	if(hBmp==NULL){										// sI
		GlobalFree(lpBits);			// DIBobt@
		GlobalFree((HGLOBAL)lpbmi);	// 
		return FALSE;
	}

//							<< pbgnh쐬 >>
	if(!isFullColor){						// tJ[Ȃꍇ̂݁B
		lpLogPal=(LPLOGPALETTE)GlobalAlloc(GMEM_DISCARDABLE|GMEM_ZEROINIT,sizeof(LOGPALETTE)+sizeof(PALETTEENTRY)*nColors);

		lpLogPal->palVersion=0x300;
		lpLogPal->palNumEntries=nColors;
		for(UINT i=0;i<nColors;i++){
			lpLogPal->palPalEntry[i].peRed=lpbmi->bmiColors[i].rgbRed;
			lpLogPal->palPalEntry[i].peGreen=lpbmi->bmiColors[i].rgbGreen;
			lpLogPal->palPalEntry[i].peBlue=lpbmi->bmiColors[i].rgbBlue;
		}

	hPal=CreatePalette(lpLogPal);			// pbgnh쐬
	}

	isSet=TRUE;					// Zbg
	return TRUE;				// I
}


//---------------------------------------------------<< 摜Z[u >>
BOOL Cfbmp::Save(LPCTSTR fname)
{
	if( isReady()==FALSE )return FALSE;				// 摜łĂȂ΃G[

	FILE *stream;									// t@CXg[
	stream = fopen( (const char*)fname,"wb" );					// t@CI[v
	if( stream==NULL )return FALSE;					// I[vłȂꍇ

	fwrite( GetBMFH(),sizeof(BITMAPFILEHEADER),1,stream);	// BITMAPFILEHEADER
	fwrite( GetBMIH(),sizeof(BITMAPINFOHEADER),1,stream);	// BITMAPINFOHEADER
	if( GetColorDepth()<24 ){								// CfbNXJ[̏ꍇ
																		// RGBQUADo
		RGBQUAD quad;
		int nColors;
		nColors=1<<GetColorDepth();										// FvZ
		for( int i=0;i<nColors;i++ ){
			quad = GetPalet(i);											// pbg擾
			fwrite( &quad,sizeof(RGBQUAD),1,stream );					// 
		}
	}

	int SizeImage;														// rbgz̃TCYvZ
	SizeImage = GetWidthByte()*GetHeight();
	fwrite( GetLPBits(),SizeImage,1,stream );						// rbgz񏑂

	fclose( stream );												// t@CN[Y

	return TRUE;													// I
}


//---------------------------------------------------<< ߉摜Z[u >>
BOOL Cfbmp::SaveStencil(LPCTSTR fname)
{
	if (isReady() == FALSE)return FALSE;				// 摜łĂȂ΃G[

	// ۑ
	FILE* stream;									// t@CXg[
	stream = fopen((const char*)fname, "wb");					// t@CI[v
	if (stream == NULL)return FALSE;				// I[vłȂꍇ

	// rbgz̃TCYvZ
	UINT uSizeImage;
	uSizeImage = (this->GetWidth() * 32) / 8;	// oCgi32bitŒj
	uSizeImage += (4 - (uSizeImage & 3)) & 3;		// SoCgE
	uSizeImage *= this->GetHeight();				// đŜ̃TCY

	// Bitmap File Header 쐬
	//UINT nColors = 1 << 32;
	UINT QuadSize = 0;

	BITMAPFILEHEADER bmfh;
	memset(&bmfh, 0, sizeof(BITMAPFILEHEADER));
	bmfh.bfType = 0x4d42;
	bmfh.bfSize = sizeof(BITMAPV4HEADER) + sizeof(BITMAPFILEHEADER) + QuadSize + uSizeImage;
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = sizeof(BITMAPV4HEADER) + sizeof(BITMAPFILEHEADER) + QuadSize;

	// Bitmap V4 Header 쐬 >>
	BITMAPV4HEADER bmih;
	memset(&bmih, 0, sizeof(BITMAPV4HEADER));
	bmih.bV4Size = sizeof(BITMAPV4HEADER);
	bmih.bV4Width = this->GetWidth();
	bmih.bV4Height = this->GetHeight();
	bmih.bV4Planes = 1;
	bmih.bV4BitCount = 32;
	bmih.bV4V4Compression = BI_BITFIELDS;
	bmih.bV4SizeImage = 0;
	bmih.bV4XPelsPerMeter = 0;
	bmih.bV4YPelsPerMeter = 0;
	bmih.bV4ClrUsed = 0;
	bmih.bV4ClrImportant = 0;
	bmih.bV4RedMask = 0x000000FF;
	bmih.bV4GreenMask = 0x0000FF00;
	bmih.bV4BlueMask = 0x00FF0000;
	bmih.bV4AlphaMask = 0xFF000000;
	bmih.bV4CSType = LCS_sRGB;
	//bmih.bV4Endpoints = xx;	N/A
	bmih.bV4GammaRed = 0;
	bmih.bV4GammaGreen = 0;
	bmih.bV4GammaBlue = 0;

	// 
	fwrite(&bmfh, sizeof(BITMAPFILEHEADER), 1, stream);	// BITMAPFILEHEADER
	fwrite(&bmih, sizeof(BITMAPV4HEADER), 1, stream);	// BITMAPV4HEADER

	//int SizeImage;														// rbgz̃TCYvZ
	for (int y = this->GetHeight() - 1; y >= 0; y--) {
		for (int x = 0; x < this->GetWidth(); x++) {
			int palIndex = this->GetPixelIndex(x, y);
			RGBQUAD quad = this->GetPixelColor(x, y);
			int mask = (1 << GetColorDepth()) - 1;

			if ((palIndex & mask) == 0) {
				fputc(0x00, stream);
				fputc(0x00, stream);
				fputc(0x00, stream);
				fputc(0xFF, stream);
			}
			else {
				fputc(0xFF, stream);
				fputc(0xFF, stream);
				fputc(0xFF, stream);
				fputc(0xFF, stream);
			}
		}
	}

	fclose(stream);												// t@CN[Y
	return TRUE;
}


//---------------------------------------------------<< ߉摜Z[u >>
BOOL Cfbmp::SaveFullColor(LPCTSTR fname)
{
	if (isReady() == FALSE)return FALSE;				// 摜łĂȂ΃G[

	// ۑ
	FILE* stream;									// t@CXg[
	stream = fopen((const char*)fname, "wb");					// t@CI[v
	if (stream == NULL)return FALSE;				// I[vłȂꍇ

	// rbgz̃TCYvZ
	UINT uSizeImage;
	uSizeImage = (this->GetWidth() * 32) / 8;	// oCgi32bitŒj
	uSizeImage += (4 - (uSizeImage & 3)) & 3;		// SoCgE
	uSizeImage *= this->GetHeight();				// đŜ̃TCY

	// Bitmap File Header 쐬
	//UINT nColors = 1 << 32;
	UINT QuadSize = 0;

	BITMAPFILEHEADER bmfh;
	memset(&bmfh, 0, sizeof(BITMAPFILEHEADER));
	bmfh.bfType = 0x4d42;
	bmfh.bfSize = sizeof(BITMAPV4HEADER) + sizeof(BITMAPFILEHEADER) + QuadSize + uSizeImage;
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = sizeof(BITMAPV4HEADER) + sizeof(BITMAPFILEHEADER) + QuadSize;

	// Bitmap V4 Header 쐬 >>
	BITMAPV4HEADER bmih;
	memset(&bmih, 0, sizeof(BITMAPV4HEADER));
	bmih.bV4Size = sizeof(BITMAPV4HEADER);
	bmih.bV4Width = this->GetWidth();
	bmih.bV4Height = this->GetHeight();
	bmih.bV4Planes = 1;
	bmih.bV4BitCount = 32;
	bmih.bV4V4Compression = BI_BITFIELDS;
	bmih.bV4SizeImage = 0;
	bmih.bV4XPelsPerMeter = 0;
	bmih.bV4YPelsPerMeter = 0;
	bmih.bV4ClrUsed = 0;
	bmih.bV4ClrImportant = 0;
	bmih.bV4RedMask = 0x000000FF;
	bmih.bV4GreenMask = 0x0000FF00;
	bmih.bV4BlueMask = 0x00FF0000;
	bmih.bV4AlphaMask = 0xFF000000;
	bmih.bV4CSType = LCS_sRGB;
	//bmih.bV4Endpoints = xx;	N/A
	bmih.bV4GammaRed = 0;
	bmih.bV4GammaGreen = 0;
	bmih.bV4GammaBlue = 0;

	// 
	fwrite(&bmfh, sizeof(BITMAPFILEHEADER), 1, stream);	// BITMAPFILEHEADER
	fwrite(&bmih, sizeof(BITMAPV4HEADER), 1, stream);	// BITMAPV4HEADER

	//int SizeImage;														// rbgz̃TCYvZ
	for (int y = this->GetHeight() - 1; y >= 0; y--) {
		for (int x = 0; x < this->GetWidth(); x++) {
			int palIndex = this->GetPixelIndex(x, y);
			RGBQUAD quad = this->GetPixelColor(x, y);

			fputc(quad.rgbRed & 0xFF, stream);
			fputc(quad.rgbGreen & 0xFF, stream);
			fputc(quad.rgbBlue & 0xFF, stream);

			int mask = (1 << GetColorDepth()) - 1;
			fputc(((palIndex & mask) == 0 ? 0x00 : 0xFF), stream);
		}
	}

	fclose(stream);												// t@CN[Y
	return TRUE;
}


//---------------------------------------------------<< 摜j >>
void Cfbmp::Free()
{
	if(isSet==FALSE)return;					// f[^ǂ܂ĂȂ΃LZ

	if( isBitOperating==FALSE ){			// rbgڑ쒆łȂ
		DeleteObject(hBmp);						// alo
	}
	if(!isFullColor){						// pbg
		if( isBitOperating==FALSE )DeleteObject(hPal);
		GlobalFree((HGLOBAL)lpLogPal);
	}
	GlobalFree(lpBits);
	GlobalFree((HGLOBAL)lpbmi);
	isSet=FALSE;
}

//---------------------------------------------------<< wcb̎wʒuɎw͈͂ŕ` >>
void Cfbmp::FrameDraw(CPoint& src,CRect& dist,CDC *pDC)
{
	if(isSet==FALSE)return;						// f[^͏ĂȂB

	CDC memDC;									// cb
	memDC.CreateCompatibleDC(pDC);				// Rp`uݒ

	CBitmap *tempbmp;
	tempbmp=CBitmap::FromHandle(hBmp);			// ꎞICBitmapObject쐬
	memDC.SelectObject(tempbmp);				// cbɑI

	if(!isFullColor){							// tJ[łȂ΃pbgrealize
		pDC->SelectPalette(CPalette::FromHandle(hPal),FALSE);
		pDC->RealizePalette();
	}

	pDC->BitBlt(dist.left,dist.top				// `I
		,abs(dist.right-dist.left)+1,abs(dist.bottom-dist.top)+1
		,&memDC,src.x,src.y,SRCCOPY);
}


//---------------------------------------------------<< Pɕ` >>
void Cfbmp::NormalDraw(CPoint& dist,CDC *pDC)
{
	if(isSet==FALSE)return;						// f[^͏ĂȂB

	CDC memDC;									// cb
	memDC.CreateCompatibleDC(pDC);				// Rp`uݒ

	CBitmap *tempbmp;
	tempbmp=CBitmap::FromHandle(hBmp);			// ꎞICBitmapObject쐬
	memDC.SelectObject(tempbmp);				// cbɑI

	if(!isFullColor){							// tJ[łȂ΃pbgrealize
		pDC->SelectPalette(CPalette::FromHandle(hPal),FALSE);
		pDC->RealizePalette();
	}

	pDC->BitBlt(dist.x,dist.y,bmih.biWidth,bmih.biHeight	// `I
		,&memDC,0,0,SRCCOPY);
}



//--------------------------<< wcb̎wʒuɎw蕔wTCYɃTCYĕ` >>
void Cfbmp::StretchDraw(CRect& src,CRect& dist,CDC *pDC)
{
	if(isSet==FALSE)return;						// f[^͏ĂȂB

	CDC memDC;									// cb
	memDC.CreateCompatibleDC(pDC);				// Rp`uݒ

	CBitmap *tempbmp;
	tempbmp=CBitmap::FromHandle(hBmp);			// ꎞICBitmapObject쐬
	memDC.SelectObject(tempbmp);				// cbɑI

	if(!isFullColor){						// tJ[łȂ΃pbgrealize
		pDC->SelectPalette(CPalette::FromHandle(hPal),FALSE);
		pDC->RealizePalette();
	}

	pDC->StretchBlt(dist.left,dist.top			// `I
		,abs(dist.right-dist.left)+1,abs(dist.bottom-dist.top)+1
		,&memDC
		,src.left,src.top
		,abs(src.right-src.left)+1,abs(src.bottom-src.top)+1
		,SRCCOPY);
}


//-----------------------------------------------------------------<< 摜̕Ԃ >>
int Cfbmp::GetWidth()
{
	if(isSet==FALSE)return 0;			// 摜ǂ܂ĂȂ΂O
	return bmih.biWidth;				// 摜̕
}


//-----------------------------------------------------------------<< 摜̍Ԃ >>
int Cfbmp::GetHeight()
{
	if(isSet==FALSE)return 0;			// 摜ǂ܂ĂȂ΂O
	return bmih.biHeight;				// 摜̍
}


//-----------------------------------------------------------------<< J[fvXԂ >>
int Cfbmp::GetColorDepth()
{
	if(isSet==FALSE)return 0;			// 摜ǂ܂ĂȂ΂O
	return bmih.biBitCount;				// 摜̃rbgfvX
}

//-----------------------------------------------------------------<< FԂ >>
int Cfbmp::GetColorNum()
{
	if(isSet==FALSE)return 0;			// 摜ǂ܂ĂȂ΂O
	return 1<<bmih.biBitCount;			// 摜̐F
}


//-----------------------------------------------------------------<< 摜̃TCYԂ >>
CSize Cfbmp::GetSize()
{
	if(isSet==FALSE)return CSize(0,0);			// 摜ǂ܂ĂȂ΂O
	CSize result;
	result.cx=bmih.biWidth;		// Zbg
	result.cy=bmih.biHeight;		// Zbg
	return result;					// TCYԂ
}


//-------------------------------------------------------------<< alonhԂ >>
HBITMAP Cfbmp::GetBmpHandle()
{
	if(isSet == FALSE)return(0);
	if(isBitOperating)return(0);			// rbg쒆ȂOԂ
	else return(hBmp);
}


//-------------------------------------------------------------<< BITMAPFILEHEADERւ̃|C^Ԃ >>
BITMAPFILEHEADER* Cfbmp::GetBMFH()
{
	return &bmfh;
}


//-------------------------------------------------------------<< BITMAPINFOHEADERւ̃|C^Ԃ >>
BITMAPINFOHEADER* Cfbmp::GetBMIH()
{
	return &bmih;
}


//-------------------------------------------------------------<< rbgzւ̃|C^Ԃ >>
void* Cfbmp::GetLPBits()
{
	return lpBits;
}

//-------------------------------------------------<< alo\̏łĂ邩ۂ >>
BOOL Cfbmp::isReady()
{
	return isSet;
}

//-------------------------------------------------<< rbgIy[Vۂ >>
BOOL Cfbmp::isBitOpe()
{
	return isBitOperating;
}


//----------------------------------------------------------<< w index ̃pbgԂ >>
RGBQUAD Cfbmp::GetPalet( int index )
{
	RGBQUAD quad;
	memset( &quad , 0 , sizeof(RGBQUAD) );
	if( isReady()==FALSE )return quad;						// łĂȂȂ0Ԃ

	int colors = 1<<bmih.biBitCount;					// FvZ
	if( bmih.biBitCount>=24 )return quad;				// tJ[Ȃ0Ԃ
	if( index >= colors )return quad;					// index ԈĂȂ0Ԃ

	return lpbmi->bmiColors[index];
}


//--------------------------------------------<< wʒũsNZ̃pbgR[hԂ >>
RGBQUAD Cfbmp::GetPixelColor( int x, int y )
{
	int cy;
	cy = bmih.biHeight-y-1;				// {gAbv̊Z

	RGBQUAD quad;
	memset( &quad , 0 , sizeof(RGBQUAD) );
	if( isReady()==FALSE )return quad;					//łĂȂȂ0Ԃ
	if( x >= bmih.biWidth )return quad;					// NbsO
	if( y >= bmih.biHeight)return quad;
	if( x<0 )return quad;
	if( y<0 )return quad;

	int colors=1<<bmih.biBitCount;						// FvZ


	if( bmih.biBitCount>=24 ){							// tJ[̏ꍇ
		int offset;									// ItZbgvZ
		offset = (GetWidthByte()*cy) + ((x*bmih.biBitCount)/8);

		BYTE *work;									// FZo
		work = ((BYTE*)lpBits)+offset;
		quad.rgbRed   = *(work+2);
		quad.rgbGreen = *(work+1);
		quad.rgbBlue  = *(work+0);
		return quad;
	}
														// QTUF̏ꍇ
	if( bmih.biBitCount==8 ){
		int offset;									// ItZbgvZ
		offset = (GetWidthByte()*cy) + ((x*bmih.biBitCount)/8);

		BYTE *work;									// FZo
		work = ((BYTE*)lpBits)+offset;
		return GetPalet( *work );
	}

	if( bmih.biBitCount==4 ){							// PUF̏ꍇ
		int offset,uplow;								// ItZbgAupper  lower
		offset = (GetWidthByte()*cy) + ((x*bmih.biBitCount)/8);
		uplow  = ( (bmih.biWidth*cy)+x )&1;

		BYTE *work;									// FZo
		work = ((BYTE*)lpBits)+offset;
		if( uplow )return GetPalet( (*work)&15 );
		else return	GetPalet( (*work)/16 );
	}

	return quad;										// T|[gĂȂrbg}bv0Ԃ
}


//--------------------------------------------<< wʒũsNZ̃CfbNXԂ >>
//  tJ[ꍇ -1(Error) Ԃ
int Cfbmp::GetPixelIndex( int x, int y )
{
	if( isReady()==FALSE )return -1;					//łĂȂȂ0Ԃ
	if( x >= bmih.biWidth )return -1;					// NbsO
	if( y >= bmih.biHeight)return -1;
	if( x<0 )return -1;
	if( y<0 )return -1;
	if( bmih.biBitCount==24 )return -1;					// tJ[ȂG[

	int cy;
	cy = bmih.biHeight-y-1;				// {gAbv̊Z

	if( bmih.biBitCount==8 ){						// QTUF̏ꍇ
		int offset;									// ItZbgvZ
		offset = (GetWidthByte()*cy) + ((x*bmih.biBitCount)/8);

		BYTE *work;									// |CgZo
		work = ((BYTE*)lpBits)+offset;
		return *work;
	}

	if( bmih.biBitCount==4 ){							// PUF̏ꍇ
		int offset,uplow;								// ItZbgAupper  lower
		offset = (GetWidthByte()*cy) + ((x*bmih.biBitCount)/8);
		uplow  = ( (bmih.biWidth*cy)+x )&1;

		BYTE *work;									// |CgZo
		work = ((BYTE*)lpBits)+offset;
		if( uplow )return (*work)&15;
		else return	((*work)/16)&15;
	}

	return -1;										// T|[gĂȂrbg}bv-1Ԃ
}



//-------------------------------------------<< rbgz̒ڑ̏ >>
void Cfbmp::PrepareBitOperation()
{
	if( isReady()==FALSE )return;						// 摜łĂȂΕԂ
	if( isBitOperating )return;							// łɏłĂȂ牽Ȃ

	DeleteObject( hBmp );								// alonĥłB
	if( !isFullColor )DeleteObject( hPal );				// pbgnh
	isBitOperating=TRUE;								// rbgz̒ڑ̏
}


//-------------------------------------------<< rbgz̒ڑI >>
void Cfbmp::EndBitOperation(CDC* pDC)
{
	if( isReady()==FALSE )return;						// 摜łĂȂȂԂ
	if( isBitOperating==FALSE )return;					// rbg̒ڑ쒆łȂΕԂ

	hBmp=CreateDIBitmap(pDC->m_hDC,&bmih,CBM_INIT,lpBits,lpbmi,DIB_RGB_COLORS);	// nh쐬
	if( !isFullColor )hPal=CreatePalette(lpLogPal);		// pbgnh쐬
	isBitOperating=FALSE;								// rbg̒ڑ쒆ł͂ȂƂ
}


//----------------------------------------------------------<< w index Ƀpbgݒ肷 >>
void Cfbmp::SetPalet( int index , RGBQUAD& quad )
{
	if( isReady()==FALSE )return;						// łĂȂȂ0Ԃ
	if( isBitOperating==FALSE )return;					// rbg̏łĂȂȂԂ
	if( bmih.biBitCount>=24 )return;

	int colors = 1<<bmih.biBitCount;					// FvZ
	if( index >= colors )return;						// index ԈĂȂ0Ԃ

	lpbmi->bmiColors[index] = quad;						// Fݒ

	lpLogPal->palPalEntry[index].peRed  =quad.rgbRed;	// log palette ɂݒ
	lpLogPal->palPalEntry[index].peGreen=quad.rgbGreen;
	lpLogPal->palPalEntry[index].peBlue =quad.rgbBlue;

	return;
}


//-------------------------------------------<< wʒuɃsNZuitJ[̎̂݁j >>
BOOL Cfbmp::SetPixelColor( int x, int y , RGBQUAD& quad )
{
	if( isReady()==FALSE )return FALSE;						// łĂȂΕԂ
	if( isBitOperating==FALSE )return FALSE;			// rbg̏łĂȂȂԂ
	if( bmih.biBitCount!=24 )return FALSE;				// tJ[ȂΕԂ

	int cy;
	cy = bmih.biHeight-y-1;				// {gAbv̊Z

	if( isReady()==FALSE )return FALSE;					//łĂȂȂFALSEԂ
	if( x >= bmih.biWidth )return FALSE;					// NbsO
	if( y >= bmih.biHeight)return FALSE;
	if( x<0 )return FALSE;
	if( y<0 )return FALSE;

	int offset;									// ItZbgvZ
		offset = (GetWidthByte()*cy) + ((x*bmih.biBitCount)/8);

	BYTE *work;									// Fzu
	work = ((BYTE*)lpBits)+offset;
	*(work+2) = quad.rgbRed;
	*(work+1) = quad.rgbGreen;
	*(work+0) = quad.rgbBlue;

	return TRUE;										// I
}


//-------------------------------------------<< wʒuɃsNZuiCfbNX̂݁j >>
BOOL Cfbmp::SetPixelIndex( int x, int y , int col )
{
	if( isReady()==FALSE )return FALSE;					// łĂȂΕԂ
	if( isBitOperating==FALSE )return FALSE;			// rbgz̒ڑ̏łĂȂΕԂ
	if( bmih.biBitCount==24 )return FALSE;				// tJ[̓_
	if( bmih.biBitCount<  4 )return FALSE;				// PUF菭Ȃ̂_iQFƂj

	int cy;
	cy = bmih.biHeight-y-1;				// {gAbv̊Z

	if( x >= bmih.biWidth )return FALSE;					// NbsO
	if( y >= bmih.biHeight)return FALSE;
	if( x<0 )return FALSE;
	if( y<0 )return FALSE;

										// QTUF̏ꍇ
	if( bmih.biBitCount==8 ){
		int offset;									// ItZbgvZ
		offset = (GetWidthByte()*cy) + ((x*bmih.biBitCount)/8);

		BYTE *work;									// |C^̈ʒuZo
		work = ((BYTE*)lpBits)+offset;
		*work = col;								// Fzu

		return TRUE;
	}

	if( bmih.biBitCount==4 ){							// PUF̏ꍇ
		int offset,uplow;								// ItZbgAupper  lower
		offset = (GetWidthByte()*cy) + ((x*bmih.biBitCount)/8);
		uplow  = ( (bmih.biWidth*cy)+x )&1;

		BYTE *work;									// FZo
		work = ((BYTE*)lpBits)+offset;
		BYTE temp;
		temp = *work;
		if( uplow ){								// ̂Srbg
			temp &= 0xF0;
			temp |= col&0x0F;
			*work = temp;
			return TRUE;
		} else {									// ̂Srbg
			temp &= 0x0F;
			temp |= (col<<4)&0xF0;
			*work = temp;
			return TRUE;
		}
	}

	return FALSE;										// ܂ŗ锤͂ȂB
														// bmih.biBitCount̒lɌ肪\
}


//-------------------------------------------<< wʒuɃsNZuiCfbNX̂݁j >>
UINT Cfbmp::GetWidthByte()
{
	UINT res;
	res = (bmih.biWidth*bmih.biBitCount)/8;							// oCg
	res += ( 4-(res&3) )&3;											// SoCgE
	return res;														// ʂԂ
}



