﻿
// bmp2grpDlg.cpp : 実装ファイル
//
#include "stdio.h"
#include "stdlib.h"

#include "pch.h"
#include "framework.h"
#include "bmp2grp.h"
#include "bmp2grpDlg.h"
#include "afxdialogex.h"
#include "resource.h"

#include "cfbmp.h"
extern "C" {
#include "RL.H"
}

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// アプリケーションのバージョン情報に使われる CAboutDlg ダイアログ

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// ダイアログ データ
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV サポート

// 実装
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// Cbmp2grpDlg ダイアログ



Cbmp2grpDlg::Cbmp2grpDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_BMP2GRP_DIALOG, pParent)
	, m_strBmpFilename(_T(""))
	, m_strOutDir(_T(""))
	, m_baseName(_T(""))
	, m_check16B(FALSE)
	, m_check256B(FALSE)
	, m_check16RL(FALSE)
	, m_check256RL(FALSE)
	, m_checkTextRL(FALSE)
	, m_checkFullColorBmp(FALSE)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void Cbmp2grpDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_BMP_FILENAME, m_strBmpFilename);
	DDX_Text(pDX, IDC_EDIT_OUTDIR, m_strOutDir);
	DDX_Text(pDX, IDC_EDIT_BASENAME, m_baseName);
	DDX_Check(pDX, IDC_CHECK_16B, m_check16B);
	DDX_Check(pDX, IDC_CHECK_256B, m_check256B);
	DDX_Check(pDX, IDC_CHECK_16RL, m_check16RL);
	DDX_Check(pDX, IDC_CHECK_256RL, m_check256RL);
	DDX_Check(pDX, IDC_CHECK_TEXTRL, m_checkTextRL);
	DDX_Check(pDX, IDC_CHECK_FULLCOLORBMP, m_checkFullColorBmp);
}

BEGIN_MESSAGE_MAP(Cbmp2grpDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_REF_OUTDIR, &Cbmp2grpDlg::OnBnClickedButtonRefOutdir)
	ON_BN_CLICKED(IDC_BUTTON_REF_BMP, &Cbmp2grpDlg::OnBnClickedButtonRefBmp)
	ON_BN_CLICKED(IDC_BUTTON_CONVERT, &Cbmp2grpDlg::OnBnClickedButtonConvert)
END_MESSAGE_MAP()


// Cbmp2grpDlg メッセージ ハンドラー

BOOL Cbmp2grpDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// "バージョン情報..." メニューをシステム メニューに追加します。

	// IDM_ABOUTBOX は、システム コマンドの範囲内になければなりません。
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// このダイアログのアイコンを設定します。アプリケーションのメイン ウィンドウがダイアログでない場合、
	//  Framework は、この設定を自動的に行います。
	SetIcon(m_hIcon, TRUE);			// 大きいアイコンの設定
	SetIcon(m_hIcon, FALSE);		// 小さいアイコンの設定

	// TODO: 初期化をここに追加します。

	return TRUE;  // フォーカスをコントロールに設定した場合を除き、TRUE を返します。
}

void Cbmp2grpDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// ダイアログに最小化ボタンを追加する場合、アイコンを描画するための
//  下のコードが必要です。ドキュメント/ビュー モデルを使う MFC アプリケーションの場合、
//  これは、Framework によって自動的に設定されます。

void Cbmp2grpDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // 描画のデバイス コンテキスト

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// クライアントの四角形領域内の中央
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// アイコンの描画
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
		RedrawScreen();
	}
}

// ユーザーが最小化したウィンドウをドラッグしているときに表示するカーソルを取得するために、
//  システムがこの関数を呼び出します。
HCURSOR Cbmp2grpDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


/// <summary>
/// 出力先フォルダを選ぶ
/// </summary>
void Cbmp2grpDlg::OnBnClickedButtonRefOutdir()
{
	UpdateData();
	CFolderPickerDialog folderDialog(m_strOutDir);

	// ダイアログ表示
	if (folderDialog.DoModal() == IDOK)
	{
		CString fullPathName = folderDialog.GetPathName();
		m_strOutDir = fullPathName;
		UpdateData(FALSE);
	}
}


void Cbmp2grpDlg::OnBnClickedButtonRefBmp()
{
	UpdateData();
	CFileDialog fileDialog(true, m_strBmpFilename);

	// ダイアログ表示
	if (fileDialog.DoModal() != IDOK) {
		return;
	}

	// フルパス取得
	CString fullPathName = fileDialog.GetPathName();
	m_strBmpFilename = fullPathName;
	UpdateData(FALSE);

	// 画像準備
	CDC* pDC = GetDC();
	BOOL bRes = m_edgeBmp.Load(m_strBmpFilename, pDC);
	if (bRes == FALSE) {
		MessageBox("BMPファイルの読み込みでエラーが発生しました。");
		m_edgeBmp.Free();
		return;
	}

	// 色数が違ったらエラー
	int depth = m_edgeBmp.GetColorDepth();
	if (depth != 8) {
		MessageBox("256色のBMPを指定してください。");
		m_edgeBmp.Free();
		return;
	}
	if ((m_edgeBmp.GetWidth() != 512) && (m_edgeBmp.GetWidth() != 1024)) {
		MessageBox("幅が512pixelもしくは1024pixelのBMPを指定してください。");
		m_edgeBmp.Free();
		return;
	}
	ReleaseDC(pDC);

	// 画像再表示
	this->RedrawScreen();
}

/// <summary>
/// 変換実行
/// </summary>
void Cbmp2grpDlg::OnBnClickedButtonConvert()
{
	// データ取り込み
	UpdateData();

	// 保存処理
	BOOL bRes = FALSE;
	if (m_check16B) {
		bRes = save16Beta();
	}
	if (m_check256B) {
		bRes = save256Beta();
	}
	if (m_check16RL) {
		bRes = save16RL();
	}
	if (m_check256RL) {
		bRes = save256RL();
	}
	if (m_checkTextRL) {
		bRes = saveTextRL();
	}
	if (m_checkFullColorBmp) {
		bRes = saveFullColorBMP();
	}

	// 終了処理
	if (!bRes) {
		MessageBox("保存処理中にエラーが発生しました");
		return;
	}
	MessageBox("変換処理完了");
}

BOOL Cbmp2grpDlg::save16Beta() {
	FILE* fn;
	CDC* pDC = GetDC();
	Cfbmp bmp;

	// ビットマップ画像を読み込む
	bmp.Load(m_strBmpFilename, pDC);
	int colorDepth = bmp.GetColorDepth();

	// 色数不正
	if (colorDepth != 8) {
		MessageBox("256色のBMPファイルを指定してください。");
		return FALSE;
	}

	// GRPデータを出力する
	CString grpFilename = CString(m_strOutDir) + "\\" + m_baseName + ".GRP";
	fn = fopen(grpFilename.GetString(), "wb");
	if (fn == NULL) {
		MessageBox("GRPファイルのファイルを新規作成できませんでした。");
		return FALSE;
	}
	for (int y = 0; y < bmp.GetHeight(); y++) {
		for (int x = 0; x < bmp.GetWidth(); x++) {
			WORD value = (BYTE)(bmp.GetPixelIndex(x, y));
			BYTE l = (BYTE)((value >> 8) & 0x00FF);
			BYTE r = (BYTE)((value) & 0x00FF);
			fputc(l, fn);
			fputc(r, fn);
		}
	}
	fclose(fn);

	// 16色パレットを出力する
	CString pal16Filename = CString(m_strOutDir) + "\\" + m_baseName + "_16.PAL";
	fn = fopen(pal16Filename, "wb");
	if (fn == NULL) {
		MessageBox("16色パレットのファイルを新規作成できませんでした。");
		return FALSE;
	}
	for (int i = 0; i < 16; i++) {
		RGBQUAD quad = bmp.GetPalet(i);
		int red = quad.rgbRed;
		int green = quad.rgbGreen;
		int blue = quad.rgbBlue;

		red = (int)(((double)red * 32.0) / 256.0);
		green = (int)(((double)green * 32.0) / 256.0);
		blue = (int)(((double)blue * 32.0) / 256.0);

		WORD value = 0;
		value += (green & 0b0000000000011111) << 11;
		value += (red & 0b0000000000011111) << 6;
		value += (blue & 0b0000000000011111) << 1;

		fputc((value >> 8) & 0xFF, fn);
		fputc(value & 0xFF, fn);
	}
	fclose(fn);

	// リソース解放
	bmp.Free();
	ReleaseDC(pDC);

	return TRUE;
}

BOOL Cbmp2grpDlg::save256Beta() {
	FILE* fn;
	CDC* pDC = GetDC();
	Cfbmp bmp;

	// ビットマップ画像を読み込む
	bmp.Load(m_strBmpFilename, pDC);
	int colorDepth = bmp.GetColorDepth();

	// 色数不正
	if (colorDepth != 8) {
		MessageBox("256色のBMPファイルを指定してください。");
		return FALSE;
	}

	// GRPデータを出力する
	CString grpFilename = CString(m_strOutDir) + "\\" + m_baseName + ".GRP";
	fn = fopen(grpFilename.GetString(), "wb");
	if (fn == NULL) {
		MessageBox("GRPファイルのファイルを新規作成できませんでした。");
		return FALSE;
	}
	for (int y = 0; y < bmp.GetHeight(); y++) {
		for (int x = 0; x < bmp.GetWidth(); x++) {
			WORD value = (BYTE)(bmp.GetPixelIndex(x, y));
			BYTE l = (BYTE)((value >> 8) & 0x00FF);
			BYTE r = (BYTE)((value) & 0x00FF);
			fputc(l, fn);
			fputc(r, fn);
		}
	}
	fclose(fn);

	// 256パレットを出力する
	CString pal256Filename = CString(m_strOutDir) + "\\" + m_baseName + "_256.PAL";
	fn = fopen(pal256Filename, "wb");
	if (fn == NULL) {
		MessageBox("256色パレットのファイルを新規作成できませんでした。");
		return FALSE;
	}
	for (int i = 0; i < 256; i++) {
		RGBQUAD quad = bmp.GetPalet(i);
		int red = quad.rgbRed;
		int green = quad.rgbGreen;
		int blue = quad.rgbBlue;

		red = (int)(((double)red * 32.0) / 256.0);
		green = (int)(((double)green * 32.0) / 256.0);
		blue = (int)(((double)blue * 32.0) / 256.0);

		WORD value = 0;
		value += (green & 0b0000000000011111) << 11;
		value += (red & 0b0000000000011111) << 6;
		value += (blue & 0b0000000000011111) << 1;

		fputc((value >> 8) & 0xFF, fn);
		fputc(value & 0xFF, fn);
	}
	fclose(fn);

	// リソースを解放
	bmp.Free();
	ReleaseDC(pDC);

	// 終了
	return TRUE;
}

BOOL Cbmp2grpDlg::save16RL() {
	FILE* fn;
	CDC* pDC = GetDC();
	Cfbmp bmp;

	// ビットマップ画像を読み込む
	bmp.Load(m_strBmpFilename, pDC);
	int colorDepth = bmp.GetColorDepth();

	// 色数不正
	if (colorDepth != 8) {
		MessageBox("256色のBMPファイルを指定してください。");
		return FALSE;
	}

	// GRPをRLに変換
	int pixelCount = bmp.GetWidth() * bmp.GetHeight();
	BYTE* source = (BYTE*)(malloc(pixelCount));
	BYTE* dest = (BYTE*)(malloc(pixelCount * 2));
	BYTE* p = NULL;
	int outSize = 0;
	CString rlFilename;

	// 16色sourceを用意
	memset(source, 0, pixelCount);
	memset(dest, 0, pixelCount * 2);
	p = source;
	for (int y = 0; y < bmp.GetHeight(); y++) {
		for (int x = 0; x < bmp.GetWidth(); x += 2) {
			BYTE l = bmp.GetPixelIndex(x, y);
			BYTE r = bmp.GetPixelIndex(x + 1, y);
			BYTE value = ((l << 4) + r) & 0xFF;
			*p++ = value;
		}
	}

	// 変換
	outSize = rl_arc_b((char*)source, (char*)dest, pixelCount / 2);

	// 書き込み
	rlFilename = CString(m_strOutDir) + CString("\\") + CString(m_baseName) + CString("_16.RL");
	fn = fopen(rlFilename, "wb");
	for (int i = 0; i < 16; i++) {
		RGBQUAD quad = bmp.GetPalet(i);
		int red = quad.rgbRed;
		int green = quad.rgbGreen;
		int blue = quad.rgbBlue;

		red = (int)(((double)red * 32.0) / 256.0);
		green = (int)(((double)green * 32.0) / 256.0);
		blue = (int)(((double)blue * 32.0) / 256.0);

		WORD value = 0;
		value += (green & 0b0000000000011111) << 11;
		value += (red & 0b0000000000011111) << 6;
		value += (blue & 0b0000000000011111) << 1;

		fputc((value >> 8) & 0xFF, fn);
		fputc(value & 0xFF, fn);
	}
	fwrite((const void*)dest, outSize, 1, fn);
	fclose(fn);

	// メモリ解放
	free(dest);
	free(source);

	// リソース解放
	bmp.Free();
	ReleaseDC(pDC);

	return TRUE;
}

BOOL Cbmp2grpDlg::save256RL() {
	FILE* fn;
	CDC* pDC = GetDC();
	Cfbmp bmp;

	// ビットマップ画像を読み込む
	bmp.Load(m_strBmpFilename, pDC);
	int colorDepth = bmp.GetColorDepth();

	// 色数不正
	if (colorDepth != 8) {
		MessageBox("256色のBMPファイルを指定してください。");
		return FALSE;
	}

	// GRPをRLに変換
	int pixelCount = bmp.GetWidth() * bmp.GetHeight();
	BYTE* source = (BYTE*)(malloc(pixelCount));
	BYTE* dest = (BYTE*)(malloc(pixelCount * 2));
	BYTE* p = NULL;
	int outSize = 0;
	CString rlFilename;

	// 256色sourceを用意
	memset(source, 0, pixelCount);
	memset(dest, 0, pixelCount * 2);
	p = source;
	for (int y = 0; y < bmp.GetHeight(); y++) {
		for (int x = 0; x < bmp.GetWidth(); x++) {
			*p++ = bmp.GetPixelIndex(x, y);
		}
	}

	// 変換
	outSize = rl_arc_b((char*)source, (char*)dest, pixelCount);

	// 書き込み
	rlFilename = CString(m_strOutDir) + CString("\\") + CString(m_baseName) + CString("_256.RL");
	fn = fopen(rlFilename, "wb");
	for (int i = 0; i < 256; i++) {
		RGBQUAD quad = bmp.GetPalet(i);
		int red = quad.rgbRed;
		int green = quad.rgbGreen;
		int blue = quad.rgbBlue;

		red = (int)(((double)red * 32.0) / 256.0);
		green = (int)(((double)green * 32.0) / 256.0);
		blue = (int)(((double)blue * 32.0) / 256.0);

		WORD value = 0;
		value += (green & 0b0000000000011111) << 11;
		value += (red & 0b0000000000011111) << 6;
		value += (blue & 0b0000000000011111) << 1;

		fputc((value >> 8) & 0xFF, fn);
		fputc(value & 0xFF, fn);
	}
	fwrite((const void*)dest, outSize, 1, fn);
	fclose(fn);

	// メモリ解放
	free(dest);
	free(source);

	bmp.Free();
	ReleaseDC(pDC);

	return TRUE;
}

BOOL Cbmp2grpDlg::saveTextRL() {
	FILE* fn;
	CDC* pDC = GetDC();
	Cfbmp bmp;

	// ビットマップ画像を読み込む
	bmp.Load(m_strBmpFilename, pDC);
	int colorDepth = bmp.GetColorDepth();

	// 色数不正
	if (colorDepth != 8) {
		MessageBox("256色のBMPファイルを指定してください。");
		return FALSE;
	}
	// サイズ不正
	if (((bmp.GetWidth() & 0xF) != 0) || (bmp.GetWidth()==0)) {
		MessageBox("横方向のサイズが16pixelの倍数のBMPファイルを指定してください。");
		return FALSE;
	}

	// 変換用バッファを確保
	int pixelCount = bmp.GetWidth() * bmp.GetHeight();
	int bufferSize = (pixelCount / 8) * 4;
	BYTE* txp = (BYTE*)malloc(bufferSize);	// BYTE型1個につき8ピクセル×4プレーン
	BYTE* dest = (BYTE*)malloc(bufferSize * 2);	// 出力先は倍のサイズを用意しておく
	if (txp == NULL) {
		// テキスト画像データ分のメモリを確保できなかった
		return FALSE;
	}
	if (dest == NULL) {
		// 出力先データの保存用メモリを確保できなかった
		return FALSE;
	}
	memset(txp, 0, bufferSize);
	memset(dest, 0, bufferSize * 2);

	// GRPをRLに変換
	BYTE* txp0 = txp + (((pixelCount / 8) * 0));
	BYTE* txp1 = txp + (((pixelCount / 8) * 1));
	BYTE* txp2 = txp + (((pixelCount / 8) * 2));
	BYTE* txp3 = txp + (((pixelCount / 8) * 3));
	BYTE temp[8], temp0, temp1, temp2, temp3;
	int x, y, i;

	// bitmapを変換
	for (y = 0; y < bmp.GetHeight(); y++) {
		for (x = 0; x < (bmp.GetWidth() / 8); x++) {
			if (((((bmp.GetWidth() / 8)) * y) + x) == 0x10000) {
				int a = 0;
			}
			// ピクセルのカラーインデックスを得る
			for (i = 0; i < 8; i++)
			{
				temp[i] = bmp.GetPixelIndex((x * 8) + i, y);
			}
			// プレーンに分解しながら配置する
			temp0 = temp1 = temp2 = temp3 = 0;
			for (i = 0; i < 8; i++)
			{
				temp3 += (((temp[i] & 8) >> 3) << (7 - i));
			}
			for (i = 0; i < 8; i++)
			{
				temp2 += (((temp[i] & 4) >> 2) << (7 - i));
			}
			for (i = 0; i < 8; i++)
			{
				temp1 += (((temp[i] & 2) >> 1) << (7 - i));
			}
			for (i = 0; i < 8; i++)
			{
				temp0 += ((temp[i] & 1) << (7 - i));
			}
			*txp0++ = temp0;
			*txp1++ = temp1;
			*txp2++ = temp2;
			*txp3++ = temp3;
		}
	}

	// RL圧縮
	int outSize = rl_arc_b((char*)txp, (char*)dest, bufferSize);

	//// BETA
	//CString betaFilename = CString(m_strOutDir) + CString("\\") + CString(m_baseName) + CString(".BTX");
	//fn = _wfopen(betaFilename, "wb");
	//fwrite((const void*)txp, bufferSize, 1, fn);
	//fclose(fn);

	// TRLを保存
	CString rlFilename = CString(m_strOutDir) + CString("\\") + CString(m_baseName) + CString(".TRL");
	fn = fopen(rlFilename, "wb");
	fwrite((const void*)dest, outSize, 1, fn);
	fclose(fn);

	// パレットブロック数を評価する
	int maxPaletIndex = 1;
	for (int i = 1; i < 256; i++) {
		RGBQUAD quad = bmp.GetPalet(i);
		if ((quad.rgbRed != 0) || (quad.rgbBlue != 0) || (quad.rgbGreen != 0)) {
			maxPaletIndex = i;
		}
	}
	int blocks = maxPaletIndex / 16;
	if ((maxPaletIndex & 0xF) != 0) {
		blocks += 1;
	}
	if (blocks >= 16) { blocks = 15; }

	// パレットを保存
	CString palFilename = CString(m_strOutDir) + CString("\\") + CString(m_baseName) + CString(".PAL");
	fn = fopen(palFilename, "wb");
	for (int i = 0; i < (blocks*16); i++) {
		RGBQUAD quad = bmp.GetPalet(i);
		int red = quad.rgbRed;
		int green = quad.rgbGreen;
		int blue = quad.rgbBlue;

		red = (int)(((double)red * 32.0) / 256.0);
		green = (int)(((double)green * 32.0) / 256.0);
		blue = (int)(((double)blue * 32.0) / 256.0);

		WORD value = 0;
		value += (green & 0b0000000000011111) << 11;
		value += (red & 0b0000000000011111) << 6;
		value += (blue & 0b0000000000011111) << 1;

		fputc((value >> 8) & 0xFF, fn);
		fputc(value & 0xFF, fn);
	}
	fclose(fn);

	// 解放
	free(txp);
	free(dest);
	bmp.Free();
	ReleaseDC(pDC);

	// 正常終了
	return TRUE;
}


/// <summary>
/// 透過BMPに変換して保存する
/// </summary>
/// <returns></returns>
BOOL Cbmp2grpDlg::saveFullColorBMP() {
	Cfbmp bmp;
	CDC* pDC = GetDC();

	// ビットマップ画像を読み込む
	bmp.Load(m_strBmpFilename, pDC);
	if (bmp.isReady() == FALSE)return FALSE;				// 画像が準備できていなければエラー

	// ファイル名を作る
	CString fullColorBmpFilename = CString(m_strOutDir) + CString("\\") + CString(m_baseName) + CString("_F.bmp");
	CString stencilBmpFilename = CString(m_strOutDir) + CString("\\") + CString(m_baseName) + CString("_F_a.bmp");
	LPCTSTR pFilename = (LPCTSTR)fullColorBmpFilename;
	LPCTSTR pFilename_a = (LPCTSTR)stencilBmpFilename;
	bmp.SaveFullColor(pFilename);
	bmp.SaveStencil(pFilename_a);

	// 解放
	bmp.Free();
	ReleaseDC(pDC);
	return TRUE;
}


/// <summary>
/// 
/// </summary>
void Cbmp2grpDlg::RedrawScreen() {
	// 準備できていなければ無視
	if (!m_edgeBmp.isReady()) {
		return;
	}

	// 表示
	CDC* pDC = GetDC();

	// 全体の倍率を得る
	double zw1 = ((double)512) / ((double)m_edgeBmp.GetWidth());
	double zw2 = ((double)512) / ((double)m_edgeBmp.GetHeight());
	double zw = min(zw1, zw2);

	// Xの縮小率を求める
	int width = (int)(m_edgeBmp.GetWidth() * zw);
	int height = (int)(m_edgeBmp.GetHeight() * zw);

	int x = 28;
	int y = 130;
	m_edgeBmp.StretchDraw(CRect(0, 0, m_edgeBmp.GetWidth(), m_edgeBmp.GetHeight()), CRect(x, y, x + width, y + height), pDC);

	// 解放
	ReleaseDC(pDC);
}

